@extends('layouts.auth.user')
@section('title', 'Invitee details')
@section('content')
    <div class="limiter">
        <div class="container-login100">
            <div class="row">
                <div class="col-md-1"></div>
                <div class="col-md-10 mb-3">
                    <p class="text-center mb-3"><x-site-logo /></p>
                    <div class="wrap-login100">
                        <form class="login100-form" method="POST" action="{{ route('store-invitee') }}">
                            @csrf
                            @if (session('error'))
                                <p class="alert alert-danger" role="alert">
                                    {{ session('error') }}
                                </p>
                            @endif
                            <div class="form-group py-3">
                                <label>Registration Type</label>
                                <select name="reg_type" required class="form-control mb-3" id="regType">
                                    <option value="">-- Select Registration type --</option>
                                    <option value="personal">Single</option>
                                    <option value="bulk">Bulk</option>
                                </select>

                                <div id="bulkReg" style="display:none">
                                    <div class="form-group">
                                        <input class="form-control" type="text" name="author"
                                            placeholder="Sponsor's Full Name">
                                        @error('author')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <input class="form-control" type="text" name="author_email"
                                            placeholder="Sponsor's Email Address">
                                        @error('author_email')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                     <div class="form-group mb-3">
                                        <input type="text" class="form-control" name="address"
                                            placeholder="Address">
                                    </div>
                                     <div class="form-group mb-3">
                                        <label for="">Have you registered before?</label>
                                        <select name="register_question" class="form-control">
                                            <option value="">--- Select ---</option>
                                            <option value="Yes">Yes</option>
                                            <option value="No">No</option>
                                        </select>
                                    </div>
                                     <div class="form-group mb-3">
                                        <select name="register_category" class="form-control">
                                            <option value="">--- Select Category ---</option>
                                            <option value="Adult">Adult</option>
                                            <option value="Teenager">Teenager</option>
                                        </select>
                                    </div>

                                      <div class="form-group mb-3">
                                        <input type="text" class="form-control" name="church_name"
                                            placeholder="Name of Church/Cellsite">
                                    </div>

                                      <div class="form-group mb-3">
                                        <input type="text" class="form-control" name="medical_condition"
                                            placeholder="Any Medical conditions ( if applicable )">
                                    </div>
                                    <input class="input100" type="hidden" name="reg_category2[]" value="Adult">
                                    <div class="form-group">
                                        <input class="form-control" type="text" name="author_contact"
                                            placeholder="Sponsor's Whatsapp / phone number">
                                        @error('author_contact')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="testimonial_wrapper">
                                    </div>
                                    <a href="javascript:void(0);" style="float: right"
                                        class="add_testimonial btn btn-danger btn-sm mb-3 text-right" title="Add field"><i
                                            class="fa fa-plus"></i>
                                        Add Field</a>
                                    <small>Add a field to register individuals you would like to sponsor alongside your own
                                        registration.</small>
                                </div>

                                <div id="singleReg" style="display: none">
                                    <div class="form-group mb-3">
                                        <input type="text" class="form-control" name="single_first_name"
                                            placeholder="Full Name">
                                        @error('single_first_name')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                     <div class="form-group mb-3">
                                        <input type="text" class="form-control" name="address"
                                            placeholder="Address">
                                    </div>

                                      <div class="form-group mb-3">
                                        <input type="text" class="form-control" name="church_name"
                                            placeholder="Name of Church/Cellsite">
                                    </div>

                                      <div class="form-group mb-3">
                                        <input type="text" class="form-control" name="medical_condition"
                                            placeholder="Any Medical conditions ( if applicable )">
                                    </div>

                                    <div class="form-group">
                                        <select name="reg_category" class="form-control" id="">
                                            <option value="">-- Select Registration Category --</option>
                                            <option value="Children">Children ₦2,000</option>
                                            <option value="Teenager">Teenager ₦4,000</option>
                                            <option value="Adult">Adult ₦7,000</option>
                                        </select>
                                        @error('reg_category')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <select name="age_group" class="form-control" id="">
                                            <option value="">-- Select Age Group --</option>
                                            <option value="18 Months - 2yrs">18 Months - 2 Years</option>
                                            <option value="3-5 Years">3-5 Years</option>
                                            <option value="6-10 Years">6-10 Years</option>
                                            <option value="11-14 Years">11-14 Years</option>
                                            <option value="15-19 Years">15-19 Years</option>
                                            <option value="20-29 Years">20-29 Years</option>
                                            <option value="30-39 Years">30-39 Years</option>
                                            <option value="40-49 Years">40-49 Years</option>
                                            <option value="50-Above Years">50-Above Years</option>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <select name="marital_status" class="form-control" id="">
                                            <option value="">-- Select Marital Status --</option>
                                            <option value="Single">Single</option>
                                            <option value="Married">Married </option>
                                        </select>
                                        @error('marital_status')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <select name="gender" class="form-control" id="">
                                            <option value="">-- Gender --</option>
                                            <option value="Male">Male</option>
                                            <option value="Female">Female</option>
                                        </select>
                                        @error('gender')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <input class="form-control" type="email" name="email" placeholder="Email Only">
                                        @error('email')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <input class="form-control" type="text" maxlength="11" name="phone"
                                            placeholder="Phone number / Whatsapp eg 090...">
                                        @error('phone')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                </div>
                                <div class="container-login100-form-btn" id="sbtn" style="display:none">
                                    <button type="submit" class="login100-form-btn">
                                        Register
                                    </button>
                                </div>


                        </form>
                    </div>
                </div>
                <div class="col-md-1"></div>
            </div>
        </div>
    </div>

    <script src="{{ asset('AdminAuth/js/jquery.min.js') }}"></script>

    <script type='text/javascript'>
        $(document).ready(function() {
            var maxField = 6; //Input fields increment limitation
            var addTestimonial = $('.add_testimonial'); //Add button selector
            var testimonial_wrapper = $('.testimonial_wrapper'); //Input field wrapper

            var TestimonialgHTML =
                '<div class="form-group"><label>Full Name</label><input class="form-control" type="text" name="first_name[]" placeholder="Full Name"> <label>Category</label> <select name="reg_category2[]" class="form-control" id=""><option value="">-- Select Registration Category --</option><option value="Children">Children ₦2,000</option><option value="Teenager">Teenager ₦4,000</option><option value="Adult">Adult ₦7,000</option></select><div class="form-group"><label>Age Group</label><select name="age_group2[]" class="form-control" id=""><option value="">-- Select Age Group --</option><option value="18 Months - 2yrs">18 Months - 2 Years</option><option value="3-5 Years">3-5 Years</option><option value="6-10 Years">6-10 Years</option><option value="11-14 Years">11-14 Years</option><option value="15-19 Years">15-19 Years</option><option value="20-29 Years">20-29 Years</option><option value="30-39 Years">30-39 Years</option><option value="40-49 Years">40-49 Years</option><option value="50-Above Years">50-Above Years</option></select></div><div class="form-group"><label>Phone</label><input class="form-control" type="text" name="phone2[]" placeholder="Phone Number (Whatsapp"><label>Email</label><input class="form-control" type="email" name="email2[]" placeholder="Email (Optional)"><label>Any Medical conditions ( if applicable )</label><input class="form-control" type="text" name="medical_condition[]" placeholder="Any Medical conditions ( if applicable )"><a href="javascript:void(0);" class="remove_testimonial btn-danger btn-sm text-white"><i class="fa fa-times py-3"></i></a></div>';
            var x = 1; //Initial field counter is 1

            $(addTestimonial).click(function() {
                //Check maximum number of input fields
                if (x < maxField) {
                    x++; //Increment field counter
                    $(testimonial_wrapper).append(TestimonialgHTML); //Add field html
                } else {
                    alert(
                    'You have reached the maximum number of fields!'); // Show alert when max is reached
                }
            });
            //Once remove button is clicked

            $(testimonial_wrapper).on('click', '.remove_testimonial', function(e) {
                e.preventDefault();
                $(this).parent('div').remove(); //Remove field html
                x--; //Decrement field counter
            });
        });
    </script>


    <script>
        $(document).ready(function() {
            $('#regType').on('change', function() {
                if (this.value == 'personal') {
                    $("#singleReg").show();
                    $("#sbtn").show();
                    $("#bulkReg").hide();
                }
                if (this.value == 'bulk') {
                    $("#bulkReg").show();
                    $("#sbtn").show();
                    $("#singleReg").hide();
                }
                if (this.value == '') {
                    $("#singleReg").hide();
                    $("#bulkReg").hide();
                    $("#sbtn").hide();
                }

            });
        });
    </script>
@endsection
