<div class="user-info">
    @if($user)
        <div class="img-cont">
            <div class="img-sizer">
                <img src="{{ $user ? (file_exists($user->photo) ? asset($user->photo) : asset('images/vector.png')) : asset('images/no-user.png') }}" 
                    alt="{{ ucfirst($user ? $user->username : 'No user') }}" 
                />
            </div>
        </div>
        <div class="user-name">{{ ucfirst($user ? $user->username : 'No user') }}</div>
        
        @if($isMoreIcon == 'true')
            <div style="display: none;" id="spinner-{{ $user ? $user->username : 'no-user' }}" class="spinner-border text-secondary spinner-border-sm" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
            <svg 
                id="load-more-arrow-{{ $user ? $user->username : 'no-user' }}"
                width="17" 
                height="17" 
                viewBox="0 0 17 17" 
                fill="none" 
                xmlns="http://www.w3.org/2000/svg"
                onclick='addTree(
                    `{{ $user ? $user->username : "no-user" }}`, 
                    `{{ $position }}`, 
                    `{{ $treePosition}}`, 
                    `{{ $isMoreIcon}}`,
                    `{{ $newPageLocationClase}}`,
                    1
                )'
            >
                <path 
                    fill-rule="evenodd" 
                    clip-rule="evenodd" 
                    d="M12.4733 0.292969H4.59832V7.57422L0.6604 7.57422L8.53582 16.8555L16.4112 7.57422L12.4733 7.57422V0.292969Z" 
                    fill="#00321C"
                ></path>
            </svg>
        @endif

        <div class="user-info-detail {{ $position }}">
            <div class="head-detail">
                <div class="img-cont">
                    <div class="img-sizer">
                        <img src="{{ $user && (file_exists($user->photo)) ? asset($user->photo) : asset('images/vector.png') }}" 
                            alt="{{ ucfirst($user ? $user->username : 'No user') }}" 
                        />
                    </div>
                </div>
                <div><b>{{ ucfirst($user ? $user->username : 'No user') }}</b></div>
                <div>Rank - {{ $user->rank }}</div>
            </div>
            <div class="bottom">
                <div class="each-detail">
                    <div>Left Pairing Points : </div>
                    <div class="grey-text"> {{ $user->binary_wallet ? number_format($user->binary_wallet->left_bv) : 0 }}</div>
                </div>
                <div class="each-detail">
                    <div>Right Pairing Points : </div>
                    <div class="grey-text"> {{ $user->binary_wallet ? number_format($user->binary_wallet->right_bv) : 0 }}</div>
                </div>
                <div class="each-detail">
                    <div>Left Team BV : </div>
                    <div class="grey-text"> {{ $user->binary_wallet ? number_format($user->binary_wallet->left_team_bv) : 0 }}</div>
                </div>
                <div class="each-detail">
                    <div>Right Team BV :</div>
                    <div class="grey-text"> {{ $user->binary_wallet ? number_format($user->binary_wallet->right_team_bv) : 0 }}</div>
                </div>
                <div class="each-detail">
                    <div>Total Order BV :</div>
                    <div class="grey-text"> {{ $user->binary_wallet ? number_format($user->binary_wallet->order_bv) : 0 }}</div>
                </div>
            </div>
        </div>
    @else
    <div class="no-user">
        <a href="{{route('user-register')}}">
        <div class="bg-cont">
                <img src="{{ asset('images/no-user.png') }}" alt="No user" />
            </div>
        </a>
    </div>
    @endif
   
</div>