@extends('layouts.admin')
@section('title','Testimonial Details')
@section('content')

<div class="min-height-200px">
    <div class="page-header">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <div class="title">
                    <h4>Testimonial Details</h4>
                </div>
                <nav aria-label="breadcrumb" role="navigation">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{route('adminDashboard')}}">Admin</a>
                        </li>
                        <li class="breadcrumb-item" aria-current="page">
                            <a href="{{route('admin.testimonial.index')}}">Testimonials</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Testimonial Details
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="col-md-6 col-sm-12 text-right">
                <div class="dropdown">
                    <a class="btn btn-primary" href="{{route('admin.testimonial.index')}}" role="button">
                        Testimonials
                    </a>

                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-8">
            <div class="pd-20 card-box mb-30">
                @if (session('message'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <strong>Success!</strong> {{session('message')}}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif
                <form role="form" action="{{route('admin.testimonial.update',$testimony->id)}}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="form-group">
                            <label for=" "> Name</label>
                            <input type="text" value="{{$testimony->name}}" class="form-control" name="name">
                            @error('name')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="">Post</label>
                            <input type="text" value="{{$testimony->post}}" class="form-control" name="post">
                            @error('post')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for=" ">Content </label>
                            <textarea name="content" class="form-control" rows="10">{{$testimony->content}}</textarea>
                            @error('content')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for=" ">New Photo </label>
                           <input type="file" name="image" class="form-control">
                           @error('content')
                           <span class="text-danger">{{$message}}</span>
                           @enderror
                        </div>
                    </div>
                    <!-- /.card-body -->

                        <button type="submit" class="btn btn-primary">Update</button>
                 
                </form>


            </div>
        </div>
        <div class="col-md-4">
            @if(file_exists($testimony->user_image))
            <div class="pd-20 card-box">
                <div class="">
                    <img src="{{asset($testimony->user_image)}}" alt="Testimonial Photo" class="avatar-photo" />
                </div>
            </div>
            @endif
        </div>
    </div>
</div>

@endsection
