@extends('layouts.admin')
@section('title','Bonus Report Manager')
@section('content')

<div class="min-height-200px">
    <div class="page-header">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <div class="title">
                    <h4>{{ucfirst(request()->type. ' '.'Bonus')}} Reports</h4>
                </div>
                <nav aria-label="breadcrumb" role="navigation">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{route('adminDashboard')}}">Admin</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Report Manager
                        </li>
                    </ol>
                </nav>
            </div>
            {{-- <div class="col-md-6 col-sm-12 text-right">
                <div class="dropdown">
                    <a class="btn btn-primary" href="{{route('admin.epins.create')}}" role="button">
            <i class="bi bi-plus-circle"></i>
            New Code
            </a>

        </div>
    </div> --}}
</div>
</div>

<div class="row pt-3">
    <!-- ./col -->
    <div class="col-md-2">
        <form action="{{request()->url()}}" method="GET">
            <div class="form-group">
                <select name="type" onchange="this.form.submit()" id="categorySelect" class="form-control">
                    <option value="{{request()->type}}">@if (request()->type) {{ucfirst(request()->type)}} @else All @endif Bonuses</option>                            
                    <option value="welcome">Welcome Bonus</option>
                    <option value="referral">Referral Bonus</option>
                    <option value="binary">Binary Bonus</option>
                    <option value="sales">Sales Bonus</option>
                    <option value="residual">Residual Bonus</option>
                    <option value="promo">Promo Bonus</option>
                    <option value="rank">Rank Bonus</option>
                    <option value="team_bonus">Team Bonus</option>
                    <option value="unilevel_activation">Unilevel Activation Bonus</option>
                    <option value="leadership">Leadership Bonus</option>
                </select>
            </div>
        </form>
    </div> <!-- ./col -->
    <div class="col-md-10">

    </div> <!-- ./col -->
</div>
<div class="card-box pb-10">
    <div class="h5 pd-20 mb-0"></div>
    @if (session('message'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <strong>Success!</strong> {{session('message')}}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    @endif
    @if (session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <strong>Error!</strong> {{session('error')}}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    @endif

    <div class="card-tools float-left px-3">
        <form action="{{request()->url()}}" method="GET">
            <div class="d-flex">
                <div class="input-group input-group-sm mx-3" style="width: 300px;">
                    <input type="text" style="height:35px" required class="form-control" value="{{request()->username ?? ''}}" placeholder="Search User by Username" name="username" id="">
                </div>
                <div>
                    <button class="btn btn-success btn-sm" type="submit">Search</button>
                    <a class="btn btn-primary btn-sm" href="{{route('admin.reports')}}">Reset</a>
                </div>

            </div>
        </form>
    </div>
    <div class="card-tools float-right px-3">
        <form action="{{request()->url()}}" method="GET">
            <div class="input-group input-group-sm" style="width: 150px;">
                <select name="take" class="form-control" onchange="this.form.submit()">
                    <option value="">-- per Page --</option>
                    <option value="25">25</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                    <option value="150">150</option>
                </select>
            </div>
        </form>
    </div>
    <table class="table nowrap">
        <thead>
            <tr>
                <th>Username</th>
                <th>Type</th>
                <th>Amount</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($reports as $report)
            <tr>
                <td>{{ucfirst($report->user->username)}}</td>
                <td>{{ucfirst($report->type)}}</td>
                <td>
                    <x-amount :amount="$report->amount" />
                </td>
                <td>
                    <x-date-format :date="$report->created_at" />
                </td>

            </tr>
            @empty
            <table>
                <tr>
                    <p class="text-center">No record found</p>

                </tr>
            </table>
            @endforelse

        </tbody>
    </table>
    <div class="px-3">{{$reports->withQueryString()->links()}}</div>
</div>
</div>

@endsection
