<?php

namespace App\Services;

use App\Models\User;
use App\Models\AdminLog;
use App\Models\UserWallet;
use App\Models\TransactionWallet;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use App\Models\UserPaymentInformation;

class UserService
{
    public static function allUsers($take)
    {
        return User::latest('id')->paginate($take ?: 20);
    }
    public function searchForUser($name, $take)
    {
        return User::where('username', $name)->paginate($take ?: 20);
    }
    public static function uersByStatus($status, $take, $name)
    {
        return User::where('status', $status)->orWhere('username', $name)->paginate($take ?: 20);
    }

    public static function edit($id)
    {
        $user = User::find($id);
        return $user;
    }

    public static function updateDetails($id, $data)
    {
        $user = User::find($id);
        $user->update([
            'username' => str_replace(' ', '', $data->username),
            'referral' => str_replace(' ', '', $data->referral),
            'password' => $data->password ?: $user->password,
            'first_name' => $data->first_name,
            'last_name' => $data->last_name,
            'email' => $data->email,
            'placement' => $data->placement,
            'position' => $data->position,
            'phone' => $data->phone,
            'gender' => $data->gender,
            'address' => $data->address,
            'city' => $data->city,
            'state' => $data->state,
            'zip' => $data->zip,
            'country' => $data->country,
            'dob' => $data->dob,
        ]);
        AdminLog::createAdminLog(
            Auth::user()->id,
            $user->id,
            'users',
            ucfirst(Auth::user()->username) . ' Updated this User Account'
        );
    }
    public static function activateUserStatus($id)
    {
        $user = User::find($id);
        $user->update(['status' => 'Active']);
        AdminLog::createAdminLog(
            Auth::user()->id,
            $user->id,
            'users',
            ucfirst(Auth::user()->username) . 'Activated this User Account'
        );
    }
    public static function updateUserStatus($id, $data)
    {
        $user = User::find($id);
        $user->update(['status' => $data]);
        AdminLog::createAdminLog(
            Auth::user()->id,
            $user->id,
            'users',
            ucfirst(Auth::user()->username) . 'Change this User Status'
        );
    }
    public static function updateBankInfo($id, $data)
    {
        $user = User::find($id);
        UserPaymentInformation::updateOrInsert(
            [
                'user_id' => $user->id
            ],
            [
                'account_name' => $data->account_name,
                'account_number' => $data->account_number,
                'bank_name' => $data->bank_name,
                'country' => $data->country,
            ]
        );
        AdminLog::createAdminLog(
            Auth::user()->id,
            $user->id,
            'user_payment_information',
            ucfirst(Auth::user()->username) . 'Updated this User Bank information'
        );
    }
    public static function deleteUser($id)
    {
        $user = User::find($id);
        if (File::exists(public_path($user->photo))) {
            File::delete(public_path($user->photo));
        }
        $user->delete();
        AdminLog::createAdminLog(
            Auth::user()->id,
            $user->id,
            'users',
            ucfirst(Auth::user()->username) . 'Deleted this User Account'
        );
    }


    //Credit And Debit Transaction Section
    public function creditWallet($data, $id)
    {
        $data->validate([
            'amount' => 'required|numeric',
        ]);
        $user = User::find($id);
        $wallet = UserWallet::where('user_id', $user->id)->first();
        DB::beginTransaction();
        try {
            if ($wallet) {
                $wallet->transaction_wallet += $data->amount;
                $wallet->save();
            } else {
                UserWallet::create([
                    'user_id' => $user->id,
                    'transaction_wallet' => $data->amount
                ]);
            }

            TransactionWallet::create([
                'user_id' => $user->id,
                'type' => "deposit",
                'credit' => $data->amount,
                'remark' => 'Funds added by the Admin',
                'status' => 'verified',
            ]);

            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
        }
    }
}
