<?php

namespace App\Services;

use App\Models\Admin;
use App\Models\AdminLog;
use Illuminate\Support\Facades\Auth;

class AdminService
{
    public static function allAdmins($take)
    {
        return Admin::latest('id')->where('role', '!=', 'super')->paginate($take ?: 20);
    }

    public static function store($data)
    {
        $admin = Admin::create([
            'username' => str_replace(' ','',$data->username),
            'email' => $data->email,
            'first_name' => $data->first_name,
            'last_name' => $data->last_name,
            'password' => $data->password,
            'role' => $data->role,
            'phone' => $data->phone,
            'address' => $data->address,
            'city' => $data->city,
            'state' => $data->state,
            'country' => $data->country,
            'bio' => $data->bio,
        ]);
        AdminLog::createAdminLog(
            Auth::user()->id,
            $admin->id,
            'admins',
            ucfirst(Auth::user()->username) . ' Added new Admin'
        );
    }
    public static function edit($id)
    {
        return Admin::find($id);
    }
    public static function update($id, $data)
    {
        $admin = Admin::find($id);
        $admin->update([
            'username' => $data->username,
            'email' => $data->email,
            'first_name' => $data->first_name,
            'last_name' => $data->last_name,
            'password' => $data->password,
            'role' => $data->role,
            'phone' => $data->phone,
            'address' => $data->address,
            'city' => $data->city,
            'state' => $data->state,
            'country' => $data->country,
            'bio' => $data->bio,
        ]);
        AdminLog::createAdminLog(
            Auth::user()->id,
            $admin->id,
            'admins',
            ucfirst(Auth::user()->username) . ' Updated Admin Details'
        );
    }
    public static function delete($id)
    {
        $admin = Admin::find($id);
        $admin->delete();
        AdminLog::createAdminLog(
            Auth::user()->id,
            $admin->id,
            'admins',
            ucfirst(Auth::user()->username) . ' Deleted ' . $admin->username . 'Account'
        );
    }
}
