<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UserPaymentInformation extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'account_name',
        'account_number',
        'bank_name',
        'country',
    ];
    function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
