<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UnilevelActivationUser extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'sponsor_id'
    ];

    static function recorder($user)
    {
        $ref = User::select('id', 'username', 'unilevel_activation_tracker')
            ->where('username', $user->referral)
            ->first();

        if ($ref) {
            if ($ref->unilevel_activation_tracker == 2) {
                self::create([
                    'user_id' => $user->id,
                    'sponsor_id' => $ref->id,
                ]);

                $ref->unilevel_activation_tracker = 0;
                $ref->save();

                return true;
            }

            $ref->unilevel_activation_tracker++;
            $ref->save();

            return true;
        }

        return false;
    }
}
