<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\EmailTemplateService;

class EmailTemplateController extends Controller
{
    public function __construct(
        private EmailTemplateService $emailTemplateService,
    ) {}
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $templates = $this->emailTemplateService->allTemplates(20);
        return view('admin.email-template.index', compact('templates'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.email-template.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'content' => 'required',
            'footer' => 'required',
        ]);
     
        $this->emailTemplateService::storeTemplate($request);
        return redirect()->back()->with('message', 'New Template added!');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $template = $this->emailTemplateService->getTemplate($id);
        if (!$template) {
            abort(404);
        }
        return view('admin.email-template.edit', compact('template'));
    }



    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $template = $this->emailTemplateService->getTemplate($id);
        if (!$template) {
            abort(404);
        }
        $this->emailTemplateService->updateTemplate($id,$request);
        return redirect()->back()->with('message', 'Details Updated Successfully!');
    }

    
}
