<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Guest\BlogController;
use App\Http\Controllers\Guest\ContactController;
use App\Http\Controllers\Guest\ProductController;
use App\Http\Controllers\Guest\DistributorController;
use App\Http\Controllers\FlutterwavePaymentController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/




Route::controller(HomeController::class)->group(function () {
    Route::get('/', 'home')->name('home');
    Route::get('/offline-registeration', 'index')->name('offline');
    Route::get('/accomodation', 'accomodationPage')->name('accomodation');
    Route::post('/accomodation', 'storeAccomodation')->name('store-accomodation');
    Route::get('/online-registeration', 'onLine')->name('online');
    Route::post('/', 'storeInvitee')->name('store-invitee');
    Route::get('/success', 'regSuccess')->name('reg-success');
    Route::get('registration-payment', 'paymentPage')->name('reg-payment');
    Route::post('registration-payment', 'regInvitee')->name('event-register');

    Route::get('/invitee-profile', 'inviteeProfile')->name('profile');
    Route::post('/invitee-profile', 'searchInvitee')->name('profile-search');
    Route::get('/invitee-details/{name}/{invitee_id}', 'inviteeDetails')->name('invitee-details');
    Route::post('/update-details', 'updateInvitee')->name('update-invitee');
});


Route::controller(FlutterwavePaymentController::class)->group(function () {
    Route::post('/online-registeration', 'initializePayment')->name('payment-onlineInvitee');
    Route::get('complete-registeration', 'storeInvitee')->name('store-onlineInvitee');
});
