@extends('layouts.admin')
@section('title','Testimonial Manager')
@section('content')

<div class="min-height-200px">
    <div class="page-header">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <div class="title">
                    <h4>Testimonial Manager</h4>
                </div>
                <nav aria-label="breadcrumb" role="navigation">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{route('adminDashboard')}}">Admin</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Testimonial Manager
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="col-md-6 col-sm-12 text-right">
                <div class="dropdown">
                    <a class="btn btn-primary" href="{{route('admin.testimonial.create')}}" role="button">
                        <i class="bi bi-plus-circle"></i>
                        Add New
                    </a>

                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-10">
            <div class="h5 pd-20 mb-0"></div>
            @if (session('message'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <strong>Success!</strong> {{session('message')}}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            @endif
            @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <strong>Error!</strong> {{session('error')}}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            @endif
           
            @forelse ($testimonies as $testimony)
            <div class="card-box pb-10 py-3">        
                <p class="px-3">{{Str::limit($testimony->content,303)}}</p>
                <p class="px-3"><b>{{ucfirst($testimony->name)}}</b> <br>
                    <i>{{ucfirst($testimony->post)}}</i>  <br>
                    <span><x-date-format :date="$testimony->created_at" /></span>
                </p>
                <p class="px-3">
                    <form action="{{route('admin.testimonial.destroy',$testimony->id)}}" class="p-3" method="POST">
                        @csrf
                        <a href="{{route('admin.testimonial.show',$testimony->id)}}" class="btn btn-info btn-sm text-white">
                            <i class="fa fa-eye"></i>
                        </a>
                        @method('DELETE')
                        <button type="submit" onclick="return confirm('Continue With Delete?')" class="btn btn-danger btn-sm" title="Delete Account"><i class="fa fa-trash"></i></button>
                    </form>
                </p>
            </div>
            <div class="pt-3"></div>
            @empty
            <p class="text-center">No record found</p>
            @endforelse
            <div class="px-3">{{$testimonies->withQueryString()->links()}}</div>
        </div>
    </div>
</div>

@endsection
