@extends('layouts.admin')
@section('title','Email Template')
@section('content')

<div class="min-height-200px">
    <div class="page-header">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <div class="title">
                    <h4>Email Template</h4>
                </div>
                <nav aria-label="breadcrumb" role="navigation">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{route('adminDashboard')}}">Admin</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                         Email Template
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="col-md-6 col-sm-12 text-right">
                {{-- <div class="dropdown">
                    <a
                        class="btn btn-primary"
                        href="{{route('admin.admins.create')}}"
                        role="button"
                    >
                    <i class="bi bi-plus-circle"></i>
                       New
                    </a>
                 
                </div> --}}
            </div>
        </div>
    </div>
    <div class="card-box pb-10">
        <div class="h5 pd-20 mb-0"></div>
        @if (session('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <strong>Success!</strong> {{session('message')}}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        @endif
        <table class="table nowrap">
            <thead>
                <tr>
                    <th>Title</th>
                    <th class="datatable-nosort">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($templates as $template)
                <tr>
                                    
                    <td>{{Str::limit($template->title,40)}}</td>
                    <td>
                        <a href="{{route('admin.email-template.show',$template->id)}}"
                            class="btn btn-info btn-sm text-white">
                            <i class="fa fa-edit"></i>
                        </a>
                    </td>
                </tr>
                @empty
                    <table>
                        <tr>
                            <p class="text-center">No record found</p>
                        </tr>
                    </table>
                @endforelse
              
                
            </tbody>
        </table>
        {{-- <div class="px-3">{{$admins->links()}}</div> --}}
    </div>
</div>

@endsection