<?php

namespace App\Services;

use App\Models\AdminLog;
use App\Models\Testimony;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

class TestimonialService
{
    public static function allTestimonials()
    {
        return Testimony::latest('id')->paginate(20);
    }
    public static function store($data)
    {
        if ($data->image) {
            $fileName = $data->name . '_' . time() . '.' . $data->image->getClientOriginalExtension();
            $user_image = UploadService::upload($data->image, 'testimonial', $fileName);
        }
        $testimonial = Testimony::create([
            'name' => $data->name,
            'post' => $data->post,
            'content' => $data->content,
            'user_image' => $data->image ? $user_image : null,
        ]);

        AdminLog::createAdminLog(
            Auth::user()->id,
            $testimonial->id,
            'testimonies',
            ucfirst(Auth::user()->username) . ' Added new Testimonial'
        );
    }
    public static function edit($id)
    {
        $testimonial = Testimony::find($id);
        return $testimonial;
    }
    public static function update($id, $data)
    {
        $testimonial = Testimony::find($id);
        if ($data->image) {
            if (File::exists(public_path($testimonial->user_image))) {
                File::delete(public_path($testimonial->user_image));
            }
            $fileName = str_replace(' ', '', $testimonial->name) . '_' . time() . '.' . $data->image->getClientOriginalExtension();
            $img_url = UploadService::upload($data->image, 'testimonial', $fileName);
        }
        $testimonial->update([
            'name' => $data->name,
            'post' => $data->post,
            'content' => $data->content,
            'user_image' => $data->image ? $img_url : $testimonial->user_image,
        ]);
        AdminLog::createAdminLog(
            Auth::user()->id,
            $testimonial->id,
            'testimonies',
            ucfirst(Auth::user()->username) . ' Updated this Testimony Details'
        );
    }


    public static function delete($id)
    {
        $testimonial = Testimony::find($id);
        if (File::exists(public_path($testimonial->user_image))) {
            File::delete(public_path($testimonial->user_image));
        }
        $testimonial->delete();
        AdminLog::createAdminLog(
            Auth::user()->id,
            $testimonial->id,
            'testimonies',
            ucfirst(Auth::user()->username) . ' Deleted Testimonial Details'
        );
    }
}
