<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class RankQualification extends Model
{
    use HasFactory;

    protected $fillable = [
        'level',
        'name',
        'pv',
        'reward',
    ];
    public function package(): BelongsTo
    {
        return $this->BelongsTo(Package::class,'package_id')->where('id','>',0);
    }
    public function sponsored_package(): BelongsTo
    {
        return $this->BelongsTo(Package::class,'sponsored_pkg_id');
    }
    public function sponsored_rank(): BelongsTo
    {
        return $this->BelongsTo(Self::class,'sponsor_rank_id');
    }
}
