<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Services\SocialSettingService;
use Illuminate\Http\Request;

class SocialSettingController extends Controller
{
    public function __construct(
        private SocialSettingService $socialSettingService
    ) {}
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $accounts = $this->socialSettingService->allAccounts(request()->take);
        return view('admin.social-setting.index', compact('accounts'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.social-setting.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'icon' => 'required',
            'url' => 'required|url',
        ]);

        $this->socialSettingService->store($request->all());
        return redirect()->back()->with('message', 'Social Account Details Added Successfully!');
    }


    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $account = $this->socialSettingService->edit($id);
        if (!$account) {
            abort(404);
        }
        return view('admin.social-setting.edit', compact('account'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $account = $this->socialSettingService->edit($id);
        if (!$account) {
            abort(404);
        }
        $this->socialSettingService->update($id, $request->all());
        return redirect()->back()->with('message', 'Account Details Updated Successfully!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $account = $this->socialSettingService->edit($id);
        if (!$account) {
            abort(404);
        }
        $this->socialSettingService->delete($id);
        return redirect()->back()->with('message', 'Account Details Deleted Successfully!');
    }
}
