<?php

namespace App\Http\Controllers\Admin;

use App\Events\AdminLogin;
use App\Models\Admin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AdminAuthController extends Controller
{
    public function index()
    {
        if (Auth::guard('admin')->check())
            return redirect()->route('adminDashboard');
        else
            return redirect()->route('showAdminLogin');
    }

    public function showLogin()
    {
        if (Auth::guard('admin')->check())
            return redirect()->route('adminDashboard');
        return view('admin.auth.login');
    }

    public function login(Request $request)
    {

        if (!$request->admin) {
            return response()->json(['status' => 'error', 'message' => 'Email/Username is required.']);
        }
        if (!$request->password) {
            return response()->json(['status' => 'error', 'message' => 'Password is required.']);
        }

        $admin = Admin::where('username', $request->admin)->orWhere('email', $request->admin)->first();
        // dd($user->status);

        if ($admin) {
            if ($admin->status == 'Blocked' || $admin->status == 'Suspended') {
                return response()->json(['status' => 'error', 'message' => 'Your account is BLOCKED or suspended, please contact the administrator for Activation!']);
            }
        }
        if (Auth::guard('admin')->attempt(['email' => $request->admin, 'password' => $request->password]) || Auth::guard('admin')->attempt(['username' => $request->admin, 'password' => $request->password])) {
            // event(new AdminLogin($admin));
            Auth::guard('admin')->login($admin);
            return response()->json(['status' => 'success', 'message' => 'Login Successful, Redirecting......']);
            //return redirect()->route('dashboard');
        } else {
            return response()->json(['status' => 'error', 'message' => 'Username/Email And Password Do not Match']);
        }
    }

    public function showForgotPassword()
    {
        return view('admin.auth.forgot-password');
    }


}
