@extends('layouts.auth.user')
@section('title', 'Invitee details')
@section('content')
    <div class="limiter">
        <div class="container-login100">
            <div class="row">
                <div class="col-md-1"></div>
                <div class="col-md-10 mb-3">
                    <p class="text-center mb-3"><x-site-logo /></p>
                    @if (session('message'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Success!</strong> {{session('message')}}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif
                    <div class="wrap-login100">
                        <form class="login100-form" action="{{ route('update-invitee') }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            @if (session('error'))
                                <p class="alert alert-danger" role="alert">
                                    {{ session('error') }}
                                </p>
                            @endif
                            @if (file_exists($invitee->profile_photo))
                            <div class="mb-3" style="max-height:100px;max-width:100px;margin:auto">
                                <img src="{{file_exists($invitee->profile_photo) ? asset($invitee->profile_photo) : 'N/A'}}" class="img-thumbnail" alt="{{$invitee->first_name}}" />
                            </div>
                            @endif
                            <div class="form-group pt-5">
                                <label for="">First Name</label>
                                <input type="text" required name="first_name" class="form-control"
                                    value="{{ $invitee->first_name }}" placeholder="First Name" id="">
                            </div>
                            <div class="form-group">
                                <label for="">Last Name</label>
                                <input type="text" required name="last_name" class="form-control" value="{{ $invitee->last_name }}"
                                    placeholder="Last Name" id="">
                            </div>
                            <div class="form-group">
                                <label for="">Gender</label>
                                <select name="gender" required class="form-control" id="">
                                    <option value="{{$invitee->gender }}">{{$invitee->gender }}</option>
                                    <option value="Male">Male</option>
                                    <option value="Female">Female</option>
                                </select>

                            </div>
                            <div class="form-group">
                                <label for="">Email</label>
                                <input type="email" name="email" required class="form-control" value="{{ $invitee->email }}"
                                    placeholder="Email" id="">
                            </div>
                            <div class="form-group">
                                <label for="">Contact</label>
                                <input type="text" name="phone" required class="form-control" value="{{ $invitee->phone }}"
                                    placeholder="Phone" id="">
                            </div>

                            <div class="form-group">
                                <label for="">Profile Photo</label>
                                <input type="file" required class="form-control" name="photo" id="">
                            </div>
                            <div class="container-login100-form-btn">
                                <button class="login100-form-btn">
                                    Update Profile
                                </button>
                            </div>


                        </form>
                    </div>
                </div>
                <div class="col-md-1"></div>
            </div>
        </div>
    </div>


@endsection
