<div class="product-cat">


    @if ($products->total() > 0)
    <p class="mt-4 text-muted">
        Products result:
        <b>{{ number_format($products->total()) }}</b>
    </p>
    @endif
</div>

<div class="col-lg-12">
    @if (session('error'))
    <div class="alert alert-danger alert-dismissible fade show my-2" role="alert">
        <strong>Error!</strong> {{session('error')}}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>

    @endif
    <div class="row g-5">
        @forelse ($products as $product)
        <div class="col-lg-6 col-md-6">
            <div class="each-product">
                <div class="img-cont" style="max-width: 250px">
                    <img src="{{ file_exists($product->featured_img) ? asset($product->featured_img) : asset('images/productt1.jpeg') }}" alt="{{ $product->name }}">
                </div>
                <div class="side-flex">
                    <div>
                        <div class="pro-name">{{ ucfirst($product->name) }}</div>
                        <div class="pri-text">{{ $product->point_value. 'PV' }}</div>
                        <div class="amount">
                            <x-amount :amount="$product->price" />
                        </div>
                    </div>
                    <form action="{{ route('product.add-to-cart') }}" method="POST">@csrf
                        <input type="hidden" name="id" value="{{ $product->id }}">
                        @if($product->available_quantity < 1) <span class="btn btn-secondary">Out of stock</span>
                            @else
                            <button type="submit" class="btn btn-primary">Add to cart</button>
                            @endif
                    </form>
                </div>
            </div>
        </div>

        @empty
        <p class="text-center">No Product(s) Available</p>
        @endforelse
    </div>
</div>
