@extends('layouts.admin')
@section('title','Distributor content Setting')
@section('content')

<div class="min-height-200px">
    <div class="page-header">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <div class="title">
                    <h4>Distributor content Setting</h4>
                </div>
                <nav aria-label="breadcrumb" role="navigation">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{route('adminDashboard')}}">Admin</a>
                        </li>
                        
                        <li class="breadcrumb-item active" aria-current="page">
                            Distributor Content Setting
                        </li>
                    </ol>
                </nav>
            </div>
            {{-- <div class="col-md-6 col-sm-12 text-right">
                <div class="dropdown">
                    <a class="btn btn-primary" href="{{route('admin.admins.index')}}" role="button">
                        Admin Manager
                    </a>

                </div>
            </div> --}}
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="pd-20 card-box mb-30">
                @if (session('message'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <strong>Success!</strong> {{session('message')}}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif
                <form role="form" action="{{route('admin.distributor-page-update')}}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Hero Heading </label>
                                    <input type="text" value="{{$distributor_content ? $distributor_content->hero_heading : ''}}" class="form-control"
                                        name="hero_heading">
                                </div>
                            </div>
                            <div class="col-md-6">
                                @if($distributor_content && file_exists($distributor_content->hero_banner))
                                <img src="{{asset($distributor_content->hero_banner)}}" class="img-thumbnail w-50" alt="">
                                @endif
                                <div class="form-group">
                                    <label for=" ">Hero Banner</label>
                                    <input type="file" class="form-control" name="hero_banner">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="">Hero Text </label>
                                   <textarea name="hero_text" id="" cols="30" class="form-control" rows="10">{{$distributor_content ? $distributor_content->hero_text : ''}}</textarea>
                                </div>
                            </div>
                          
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">First Section Heading One</label>
                                    <input type="text" value="{{$distributor_content ? $distributor_content->first_section_heading_one : ''}}" class="form-control"
                                        name="first_section_heading_one">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">First Section Heading Two</label>
                                    <input type="text" value="{{$distributor_content ? $distributor_content->first_section_heading_two : ''}}" class="form-control"
                                        name="first_section_heading_two">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">First Section Heading Three</label>
                                    <input type="text" value="{{$distributor_content ? $distributor_content->first_section_heading_three : ''}}" class="form-control"
                                        name="first_section_heading_three">
                                </div>
                            </div>
                            
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="">First Section Text One</label>
                                   <textarea name="first_section_text_one" id="" cols="30" class="form-control" rows="10">{{$distributor_content ? $distributor_content->first_section_text_one : ''}}</textarea>
                                </div>
                            </div>
                          
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="">First Section Text Two</label>
                                   <textarea name="first_section_text_two" id="" cols="30" class="form-control" rows="10">{{$distributor_content ? $distributor_content->first_section_text_two : ''}}</textarea>
                                </div>
                            </div>
                          
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="">First Section Text Three</label>
                                   <textarea name="first_section_text_three" id="" cols="30" class="form-control" rows="10">{{$distributor_content ? $distributor_content->first_section_text_three : ''}}</textarea>
                                </div>
                            </div>
                          
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Second Section Heading </label>
                                    <input type="text" value="{{$distributor_content ? $distributor_content->second_section_heading : ''}}" class="form-control"
                                        name="second_section_heading">
                                </div>
                            </div>
                            <div class="col-md-6">
                                @if($distributor_content && file_exists($distributor_content->second_section_banner))
                                <img src="{{asset($distributor_content->second_section_banner)}}" class="img-thumbnail w-50" alt="">
                                @endif
                                <div class="form-group">
                                    <label for=" ">Second Section Banner</label>
                                    <input type="file" class="form-control" name="second_section_banner">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="">Second Section Text </label>
                                   <textarea name="second_section_text" id="" cols="30" class="form-control" rows="10">{{$distributor_content ? $distributor_content->second_section_text : ''}}</textarea>
                                </div>
                            </div>
                          
                        </div>

                      

                    </div>
                    <!-- /.card-body -->

                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Update Setting</button>
                    </div>
                </form>


            </div>
        </div>
      
    </div>

   
</div>

@endsection
