@extends('layouts.admin')
@section('title','New Admin')
@section('content')

<div class="min-height-200px">
    <div class="page-header">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <div class="title">
                    <h4>New Admin</h4>
                </div>
                <nav aria-label="breadcrumb" role="navigation">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{route('adminDashboard')}}">Admin</a>
                        </li>
                        <li class="breadcrumb-item" aria-current="page">
                            Sub Admins
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            New Admin
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="col-md-6 col-sm-12 text-right">
                <div class="dropdown">
                    <a class="btn btn-primary" href="{{route('admin.admins.index')}}" role="button">
                        Admin Manager
                    </a>

                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="pd-20 card-box mb-30">
                @if (session('message'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <strong>Success!</strong> {{session('message')}}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif
                <form action="{{route('admin.admins.store')}}" method="POST">
                    @csrf
                    <div class="form-group">
                        <label>Username</label>
                        <input class="form-control" placeholder="Username" value="{{old('username')}}" type="text" required name="username" />
                        @error('username')
                        <span class="text-danger">{{$message}}</span>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label>Email</label>
                        <input class="form-control" value="{{old('email')}}" name="email" required type="email" placeholder="Enter Email" />
                        @error('email')
                        <span class="text-danger">{{$message}}</span>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label>First Name</label>
                        <input class="form-control" value="{{old('first_name')}}" name="first_name" placeholder="First Name" type="text" />
                    </div>
                    <div class="form-group">
                        <label>Last Name</label>
                        <input class="form-control" value="{{old('last_name')}}" placeholder="Last Name" name="last_name" type="text" />
                    </div>
                    <div class="form-group">
                        <label>Contact</label>
                        <input class="form-control" maxlength="12" value="{{old('phone')}}" placeholder="Contact Phone Number" name="phone" type="text" />
                        @error('phone')
                        <span class="text-danger">{{$message}}</span>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label>Password</label>
                        <input class="form-control" minlength="6" maxlength="10" required placeholder="Password" value="{{old('password')}}" name="password" type="password" />
                       
                    </div>
                    <div class="form-group">
                        <label for="">Role</label>
                        <select name="role" required class="form-control">
                            <option value="">--- Select ---</option>
                            <option value="user-manager">User Manager</option>
                            <option value="content-manager">Content Manager</option>
                            <option value="inventory-manager">Inventory Manager</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Address</label>
                        <input class="form-control" value="{{old('address')}}" placeholder="Address" name="address" type="text" />
                    </div>
                    <div class="form-group">
                        <label>City</label>
                        <input class="form-control" value="{{old('city')}}" placeholder="City" name="city" type="text" />
                    </div>
                    <div class="form-group">
                        <label>State</label>
                        <input class="form-control" placeholder="State" value="{{old('state')}}" name="state" type="text" />
                    </div>
                    <div class="form-group">
                        <label for=" ">Country</label>
                        <select name="country" class="form-control">
                            <x-country-list />
                        </select>
                    </div>
                    <div class="form-group">
                        <label>About Me</label>
                        <textarea name="bio" class="form-control" id="" cols="30" rows="10"></textarea>
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn btn-success">Add Admin</button>
                    </div>
                </form>


            </div>
        </div>
    </div>
</div>

@endsection
