<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('configurations', function (Blueprint $table) {
            $table->id();
            $table->double('child_reg_fee')->default(0);
            $table->double('adult_reg_fee')->default(0);
            $table->double('max_reg_bulk')->default(0);
            $table->integer('paystack_perc')->default(0)->comment('Paystack charges percentage');
            $table->double('paystack_fixed')->default(0)->comment('Paystack fixed prize for charges');
            $table->double('paystack_max')->default(0)->comment('Paystack maximum charge per transaction');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('configurations');
    }
};
