<?php

namespace App\Services;

use App\Models\AdminLog;
use App\Models\SupportTicket;
use App\Models\SupportTicketComment;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;


class SupportTicketService
{
    public static function allTickets($take)
    {
        return SupportTicket::latest('id')->paginate($take ?: 20);
    }
    public static function getTicket($ticket)
    {
        return SupportTicket::where('ticket_number', $ticket)->first();
    }
    
    public static function replyToTicket($id, $data)
    {
        $ticket = SupportTicket::find($id);
        if ($data->attachments) {
            $fileName = $data->attachments->getClientOriginalName() . time() . '.' . $data->attachments->getClientOriginalExtension();
            $file_url = UploadService::upload($data->attachments, 'tickets', $fileName);
        }
        $comment = SupportTicketComment::create([
            'user_id' => Auth::user()->id,
            'support_ticket_id' => $ticket->id,
            'support_ticket_number' => $ticket->ticket_number,
            'commenter' => 'Admin',
            'message' => $data->message,
            'attachments' => $data->attachments ? $file_url : $ticket->attachments,
        ]);
        $adm = Auth::user();
        AdminLog::createAdminLog(
            $adm->id,
            $comment->id,
            'support_ticket_comments',
            ucfirst($adm->username) . ' Replied To Ticket Comments'
        );
    }

    public static function closeTicket($ticket_number)
    {
        $ticket = SupportTicket::where('ticket_number',$ticket_number)->first();
        $ticket->update([
            'status' => 'Closed',
        ]);
        $adm = Auth::user();
        AdminLog::createAdminLog(
            $adm->id,
            $ticket->id,
            'support_tickets',
            ucfirst($adm->username) . ' Closed this Ticket and end conversation'
        );
    }

    public static function deleteTicket($id)
    {
        $ticket = SupportTicket::find($id);
        if (File::exists(public_path($ticket->attachments))) {
            File::delete(public_path($ticket->attachments));
        }
        SupportTicketComment::where('support_ticket_id', $ticket->id)->delete();
        $ticket->delete();
        $adm = Auth::user();
        AdminLog::createAdminLog(
            $adm->id,
            $ticket->id,
            'support_tickets',
            ucfirst($adm->username) . ' Deleted this Ticket and end conversation'
        );
    }
}
