<?php

namespace App\Services;

use App\Models\AdminLog;
use App\Models\Announcement;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

class AnnouncementService
{
    public static function allAnnouncements($take)
    {
        return Announcement::latest('id')->paginate($take ?: 20);
    }

    public static function getAnnouncement($id)
    {
        return Announcement::find($id);
    }

    public static function store($data)
    {
        if (file($data->banner)) {
            $fileName = $data->banner->getClientOriginalName() . '_' . time() . '.' . $data->banner->getClientOriginalExtension();
            $img_url = UploadService::upload($data->banner, 'announcement', $fileName);
        }
        $announcement = Announcement::create([
            'title' => $data->title,
            'content' => $data->content,
            'banner' => $data->banner ? $img_url : null
        ]);
        $adm = Auth::user();
        AdminLog::createAdminLog(
            $adm->id,
            $announcement->id,
            'announcements',
            'New Announcement Added by' . ucfirst($adm->username)
        );
    }

    public static function update($id, $data)
    {
        $announcement = Announcement::find($id);
        if (file($data->banner)) {
            if (File::exists(public_path($announcement->banner))) {
                File::delete(public_path($announcement->banner));
            }
            $fileName = str_replace(' ', '', $data->banner->getClientOriginalName()) . '_' . time() . '.' . $data->banner->getClientOriginalExtension();
            $img_url = UploadService::upload($data->banner, 'announcement', $fileName);
        }
        $announcement->update([
            'title' => $data->title,
            'content' => $data->content,
            'banner' => $data->banner ? $img_url : $announcement->banner,
        ]);
        $adm = Auth::user();
        AdminLog::createAdminLog(
            $adm->id,
            $announcement->id,
            'announcements',
            'Announcement Details Edited by' . ucfirst($adm->username)
        );
    }

    public static function delete($id)
    {
        $announcement = Announcement::find($id);
        if (!$announcement) {
            abort(404);
        }
        if (File::exists(public_path($announcement->banner))) {
            File::delete(public_path($announcement->banner));
        }
        $announcement->delete();
        $adm = Auth::user();
        AdminLog::createAdminLog(
            $adm->id,
            $announcement->id,
            'announcements',
            'Announcement Details Deleted by' . ucfirst($adm->username)
        );
    }
}
