<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UnilevelStat extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'level_1_m_pv',
        'level_2_m_pv',
        'level_3_m_pv'
    ];

    static function record($user, $pv)
    {
        $config = Configuration::first();

        $uplines = User::uplines($user->username, $config->unilevel_depth);
        for ($i=0; $i < count($uplines); $i++) {
            $level = $i+1;

            if (isset($uplines[$i]) && isset($uplines[$i]->id)) {
                $upline = $uplines[$i];

                $unilevelStat = UnilevelStat::where('user_id', $upline->id)->first();
                $column_m = 'level_'.$level.'_m_pv';
                $column = 'level_'.$level.'_pv';

                if ($level <= 7) {
                    if ($unilevelStat) {
                        $unilevelStat->$column_m = $unilevelStat->$column_m + $pv;
                        $unilevelStat->$column = $unilevelStat->$column + $pv;
                        $unilevelStat->save();
                    }
                    else {
                        UnilevelStat::create([
                            'user_id' => $upline->id,
                            $column_m => $pv,
                            $column => $pv,
                        ]);
                    }
                }
                else {
                    $column_m = 'level_'.$level.'_m_pv';
                    $column = 'level_'.$level.'_pv';
                    if ($unilevelStat) {
                        $otherStats_m = json_decode($unilevelStat->other_level_m_pv);
                        $otherStats = json_decode($unilevelStat->other_level_pv);
                        if (isset($otherStats_m->$column_m)) {
                            $otherStats_m->$column_m = $otherStats_m->$column_m + $pv;
                            $otherStats->$column = $otherStats->$column + $pv;
                        }
                        else {
                            $otherStats_m = [$column_m => $pv];
                            $otherStats = [$column => $pv];
                        }
                        $unilevelStat->other_level_m_pv = json_encode($otherStats_m);
                        $unilevelStat->other_level_pv = json_encode($otherStats);
                        $unilevelStat->save();
                    }
                    else {
                        $row_m = [$column_m => $pv];
                        $row = [$column => $pv];
                        UnilevelStat::create([
                            'user_id' => $upline->id,
                            'other_level_m_pv' => json_encode($row_m),
                            'other_level_pv' => json_encode($row),
                        ]);
                    }
                }
            }
        }

        return;
    }
}
