<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UpdatePersonalInfoController extends Controller
{
    public function __construct()
    {
        // Check if verified otherwise redirect to verification page
    }

    function show()
    {
        $user = Auth::user();
        if (!$user) {
            return redirect()->route('register');
        }

        return view('auth.update-personal-info', ['user' => $user]);
    }

    function update(Request $request)
    {
        $user = Auth::user();

        $request->validate([
            'first_name' => 'required',
            'last_name' => 'required',
            'phone' => 'required',
            'gender' => 'required',
            'country' => 'required',
        ]);

        $request['lastseen_ip'] = request()->ip();
        $request['lastseen_at'] = Carbon::now()->toDateTimeString();

        User::find($user->id)->update([
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'phone' => $request->phone,
            'gender' => $request->gender,
            'country' => $request->country,
        ]);

        return redirect()
            ->route('payment.show')
            ->with('status', 'Account created successfully, please enter your payment information');
    }
}
