
<?php $__env->startSection('title','Invitees Manager'); ?>
<?php $__env->startSection('content'); ?>

<div class="min-height-200px">
    <div class="page-header">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <div class="title">
                    <h4>Invitees Manager</h4>
                </div>
                <nav aria-label="breadcrumb" role="navigation">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route('adminDashboard')); ?>">Admin</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Invitees Manager
                        </li>
                    </ol>
                </nav>
            </div>
            
</div>
</div>



<div class="card-box pb-10">
    <div class="h5 pd-20 mb-0"></div>
    <?php if(session('message')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <strong>Success!</strong> <?php echo e(session('message')); ?>

        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    <?php endif; ?>
    <?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <strong>Error!</strong> <?php echo e(session('error')); ?>

        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    <?php endif; ?>
    <?php if(session('errorMessage')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <strong>Error!</strong> <?php echo e(session('errorMessage')); ?>

        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    <?php endif; ?>

    <div class="card-tools float-left px-3 my-2">
        <form action="<?php echo e(request()->url()); ?>" method="GET">
            <div class="d-flex">
                <div class="input-group input-group-sm mx-3" style="width: 300px;">
                    <input type="text" style="height:35px" required class="form-control" value="<?php echo e(request()->username ?? ''); ?>" placeholder="Search user by Username" name="username" id="">
                </div>
                <div>
                    <button class="btn btn-success btn-sm" type="submit">Search</button>
                    <a class="btn btn-primary btn-sm" href="<?php echo e(request()->url()); ?>">Reset</a>
                </div>

            </div>
        </form>
        <span class=""><a href="<?php echo e(route('export-invitees')); ?>" class="btn btn-secondary btn-sm">Export CSV</a></span>
       
    </div>
    <div class="card-tools float-right px-3">
        <form action="<?php echo e(request()->url()); ?>" method="GET">
            <div class="input-group input-group-sm" style="width: 150px;">
                <select name="take" class="form-control" onchange="this.form.submit()">
                    <option value="">-- per Page --</option>
                    <option value="25">25</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                    <option value="150">150</option>
                </select>
            </div>
        </form>
    </div>
    <table class="table nowrap">
        <thead>
            <tr>
                <th>Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Gender</th>
                <th>Status</th>
                <th>Date</th>
                <th class="datatable-nosort">Action</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $invitees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invitee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td>
                    <?php echo e(ucfirst($invitee->name)); ?>

                </td>
               
                <td>
                    <?php echo e($invitee->email ?? 'N/A'); ?>

                </td>
                <td>
                    <?php echo e($invitee->phone ?? 'N/A'); ?>

                </td>
                <td>
                    <?php echo e($invitee->gender ?? 'N/A'); ?>

                </td>
               
                <td>
                    <?php if($invitee->status == 1): ?>
                    <span class="badge bg-success text-white">Approved</span>
                  
                    <?php endif; ?>
                    <?php if($invitee->status == 0): ?>
                    <span class="badge bg-secondary text-white">Pending</span>
                    <?php endif; ?>
                </td>
                <td>
                    <?php if (isset($component)) { $__componentOriginal5133b355caac01305fe863ffe5d01930 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5133b355caac01305fe863ffe5d01930 = $attributes; } ?>
<?php $component = App\View\Components\DateFormat::resolve(['date' => $invitee->created_at] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('date-format'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\DateFormat::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5133b355caac01305fe863ffe5d01930)): ?>
<?php $attributes = $__attributesOriginal5133b355caac01305fe863ffe5d01930; ?>
<?php unset($__attributesOriginal5133b355caac01305fe863ffe5d01930); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5133b355caac01305fe863ffe5d01930)): ?>
<?php $component = $__componentOriginal5133b355caac01305fe863ffe5d01930; ?>
<?php unset($__componentOriginal5133b355caac01305fe863ffe5d01930); ?>
<?php endif; ?>
                </td>
                <td>
                    <a href="" class="btn btn-info btn-sm text-white">
                        <i class="fa fa-eye"></i>
                    </a>

                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <table>
                <tr>
                    <p class="text-center">No record found</p>
                </tr>
            </table>
            <?php endif; ?>


        </tbody>
    </table>
    <div class="px-3"><?php echo e($invitees->withQueryString()->links()); ?></div>
</div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\HP\Documents\Training\event-app\resources\views/admin/invitee/index.blade.php ENDPATH**/ ?>