<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\ProfileController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\AdminAuthController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\ActivityLogController;
use App\Http\Controllers\Admin\TestimonialController;
use App\Http\Controllers\Admin\EmailTemplateController;
use App\Http\Controllers\Admin\SocialSettingController;
use App\Http\Controllers\Admin\InviteeManagerController;

Route::group(['prefix' => 'administrator'], function () {

    Route::controller(AdminAuthController::class)->group(function () {
        Route::get('/', 'index')->name('adminIndex');
        Route::get('/login', 'showLogin')->name('showAdminLogin');
        Route::post('/login', 'login')->name('adminLogin');
        Route::get('/forgot-password', 'showForgotPassword')->name('showForgotPassword');
        Route::post('/forgot-password', 'forgotPassword')->name('forgotPassword');
    });


    Route::middleware(['auth:admin'])->group(function () {
        Route::controller(DashboardController::class)->group(function () {
            Route::get('/dashboard', 'index')->name('adminDashboard');
            Route::get('/chat', 'chatPage')->name('chat');
            Route::get('/messages/{id}', 'chatDetails')->name('chatDetails');
            Route::post('/messages/{id}', 'replyMessage')->name('replyMessage');
        });

        Route::controller(ActivityLogController::class)->group(function () {
            Route::get('/activity-logs', 'activityLogs')->name('admin.activity-logs');
            Route::get('/login-activities', 'loginActivities')->name('admin.login-activities');
        });


        //UserPayout Manager Section
        Route::controller(InviteeManagerController::class)->prefix('invitees')->group(function () {
            Route::post('/approve/{id}', 'approveInvitee')->name('admin.approve-invitee');
            Route::get('/export', 'exportInvitee')->name('export-invitees');
            Route::get('/export-card', 'printIdBulk')->name('export-card-invitees');
            Route::get('/details/{id}', 'details')->name('invitee.details');
            Route::get('/', 'index')->name('invitees');
        });


        //email-template
        Route::resource('email-template', EmailTemplateController::class, ["as" => "admin"]);

        //Social Setting Accounts Manager
        Route::resource('social-setting', SocialSettingController::class, ["as" => "admin"]);

        //Testimonial Manager
        Route::resource('testimonial', TestimonialController::class, ["as" => "admin"]);


        //Setting section
        Route::controller(SettingController::class)->group(function () {
            Route::get('/configuration', 'configSetting')->name('admin.config');
            Route::get('/website-setting', 'websiteSetting')->name('admin.website');

            Route::get('/terms', 'termsAndCondition')->name('admin.terms');
            Route::get('/privacy', 'privacy')->name('admin.privacy');

            Route::put('/terms/update', 'updateTermsAndCondition')->name('admin.terms-update');
            Route::put('/privacy/update', 'updatePrivacy')->name('admin.privacy-update');

            Route::get('/home-page', 'homePageSetting')->name('admin.home-page');
            Route::get('/distributor-page', 'distributorPageSetting')->name('admin.distributor-page');
            Route::get('/about-us', 'aboutUs')->name('admin.about-us');
            Route::put('/configuration/update', 'updateConfigSetting')->name('admin.config-update');
            Route::put('/website-setting/update', 'updateSiteSetting')->name('admin.website-update');
            Route::put('/home-page/update', 'updatehomePage')->name('admin.home-page-update');
            Route::put('/distributor-page/update', 'updateDistributorPage')->name('admin.distributor-page-update');
            Route::put('/about-us/update', 'updateAboutUs')->name('admin.about-us-update');
            Route::put('/updateAboutUsBanner', 'updateAboutUsBanner')->name('admin.updateAboutUsBanner');
            Route::put('/updateSiteLogo', 'updateSiteLogo')->name('admin.updateSiteLogo');
            Route::put('/updateSiteFavicon', 'updateSiteFavicon')->name('admin.updateSiteFavicon');
            Route::put('/updateDashboardLogo', 'updateDashboardLogo')->name('admin.updateDashboardLogo');
        });


        Route::controller(ProfileController::class)->group(function () {
            Route::get('/logout', 'logout')->name('admin.logout');
            Route::prefix('profile')->group(function () {
                Route::get('/', 'profile')->name('admin.profile');
                Route::post('/', 'update')->name('admin.profile-update');
                Route::get('/change-password', 'showChangePassword')->name('admin.password');
                Route::post('/change-password', 'changePassword')->name('admin.password-update');
            });
        });
    });
});
