<?php

namespace App\Services;

use App\Models\User;
use Illuminate\Support\Str;

class BinaryTreeService
{
    public static function binaryBuilder($username, $depth=3)
    {
        $downlinesTree = [];
        for ($i=0; $i < $depth; $i++) {
            $level = $i+1;
            $downlines = User::userDownlinersPlacement($username, $level, 14, 1);
            foreach ($downlines['user'] as $value) {
                $eachUser = User::where('username', $value)->with('binary_wallet')->first();
                $eachUser['level'] = $level;

                array_push($downlinesTree, $eachUser);
            }
        }
        
        $downlinesData = [
            'root' => User::where('username', $username)->with('binary_wallet')->first()
        ];

        for ($i=0; $i < count($downlinesTree); $i++) {
            $user =  $downlinesTree[$i];
            if ($user->level == 1) {
                if (strtolower($user->position) == 'left') {
                    $downlinesData['rootLeft'] = $user;
                }
                else {
                    $downlinesData['rootRight'] = $user;
                }
            }
            else if ($user->level == 2) {
                if (isset($downlinesData['rootLeft']) && strtolower($downlinesData['rootLeft']->username) == strtolower($user->placement)) {
                    if (strtolower($user->position) == 'left') {
                        $downlinesData['rootLeftLeft'] = $user;
                    }
                    else {
                        $downlinesData['rootLeftRight'] = $user;
                    }
                }
                elseif (isset($downlinesData['rootRight']) && strtolower($downlinesData['rootRight']->username) == strtolower($user->placement)) {
                    if (strtolower($user->position) == 'left') {
                        $downlinesData['rootRightLeft'] = $user;
                    }
                    else {
                        $downlinesData['rootRightRight'] = $user;
                    }
                }
            }
            else if ($user->level == 3) {
                if (isset($downlinesData['rootLeftLeft']) && strtolower($downlinesData['rootLeftLeft']->username) == strtolower($user->placement)) {
                    if (strtolower($user->position) == 'left') {
                        $downlinesData['leftLeftLeft'] = $user;
                    }
                    else {
                        $downlinesData['leftLeftRight'] = $user;
                    }
                }
                elseif (isset($downlinesData['rootLeftRight']) && strtolower($downlinesData['rootLeftRight']->username) == strtolower($user->placement)) {
                    if (strtolower($user->position) == 'left') {
                        $downlinesData['leftRightLeft'] = $user;
                    }
                    else {
                        $downlinesData['leftRightRight'] = $user;
                    }
                }

                else if (isset($downlinesData['rootRightLeft']->username) && strtolower($downlinesData['rootRightLeft']->username) == strtolower($user->placement)) {
                    if (strtolower($user->position) == 'left') {
                        $downlinesData['rightLeftLeft'] = $user;
                    }
                    else {
                        $downlinesData['rightLeftRight'] = $user;
                    }
                }
                elseif (isset($downlinesData['rootRightRight']) && strtolower($downlinesData['rootRightRight']->username) == strtolower($user->placement)) {
                    if (strtolower($user->position) == 'left') {
                        $downlinesData['rightRightLeft'] = $user;
                    }
                    else {
                        $downlinesData['rightRightRight'] = $user;
                    }
                }
            }
        }

        // return $downlinesTree;
        return $downlinesData;
    }

}
