<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UserSubscription extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'package_id',
        'bv',
    ];

    function user() : BelongsTo
    {
        return $this->belongsTo(User::class,'user_id');
    }

    function package() : BelongsTo
    {
        return $this->belongsTo(Package::class)->where('min_pv', '>=', 0);
    }

    function package_alt() : BelongsTo
    {
        return $this->belongsTo(Package::class);
    }
   
    static function maxPackageChecker($newBV) {
        $maxPackage = Package::max('min_pv')->first();
        if ($newBV > $maxPackage->min_pv) {
            return ($newBV - $maxPackage->min_pv);
        }

        return $newBV;
    }
}
