<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Support\Facades\DB;

class Payout extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'amount',
        'fee',
        'account_name',
        'account_number',
        'bank',
        'status',
        'date_paid',
    ];

    function bank_info(): HasOne {
        return $this->hasOne(UserPaymentInformation::class, 'user_id', 'user_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class)->withDefault([
            'name' => 'guest'
        ]);
    }

    static function stats()
    {
        return DB::select(
            "SELECT
                (SELECT ROUND(COUNT(`id`), 2) FROM `payouts`) AS total_requests,
                (SELECT ROUND(COUNT(`id`), 2) FROM `payouts` WHERE `status`='approved' ) AS total_approved,
                (SELECT ROUND(COUNT(`id`), 2) FROM `payouts` WHERE `status`='pending' ) AS total_pending,
                (SELECT ROUND(COUNT(`id`), 2) FROM `payouts` WHERE `status`='cancelled' ) AS total_cancelled,
                (SELECT ROUND(COUNT(`id`), 2) FROM `payouts` WHERE `status`='forfeited' ) AS total_forfeited,
                (SELECT ROUND(SUM(`amount`), 2) FROM `payouts`) AS total_payouts,
                (SELECT ROUND(SUM(`fee`), 2) FROM `payouts`) AS total_payout_fee,

                (SELECT ROUND(SUM(`amount`), 2)
                    FROM `payouts`
                    WHERE `created_at` >= CURDATE() AND `created_at` < CURDATE() + INTERVAL 1 DAY
                ) AS total_payout_today,
                (SELECT ROUND(SUM(`fee`), 2)
                    FROM `payouts`
                    WHERE `created_at` >= CURDATE() AND `created_at` < CURDATE() + INTERVAL 1 DAY
                ) AS total_payout_fee_today,

                (SELECT ROUND(SUM(`amount`), 2)
                    FROM `payouts`
                    WHERE (YEARWEEK(`created_at`) = YEARWEEK(CURDATE()))
                ) AS total_payout_week,
                (SELECT ROUND(SUM(`fee`), 2)
                    FROM `payouts`
                    WHERE (YEARWEEK(`created_at`) = YEARWEEK(CURDATE()))
                ) AS total_payout_fee_week,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `payouts`
                    WHERE MONTH(created_at) = MONTH(NOW()) AND YEAR(created_at) = YEAR(NOW())
                ) AS total_payout_month,

                (SELECT
                    ROUND(SUM(`fee`), 2)
                    FROM `payouts`
                    WHERE MONTH(created_at) = MONTH(NOW()) AND YEAR(created_at) = YEAR(NOW())
                ) AS total_payout_fee_month,

                (SELECT ROUND(SUM(`amount`), 2)
                    FROM `payouts`
                    WHERE (YEAR(`created_at`) = YEAR(CURDATE()))
                ) AS total_payout_year,
                (SELECT ROUND(SUM(`fee`), 2)
                    FROM `payouts`
                    WHERE (YEAR(`created_at`) = YEAR(CURDATE()))
                ) AS total_payout_fee_year
            "
        )[0];
    }
}
