<?php

namespace App\Models;

use App\Services\CacheService;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class BinaryWallet extends Model
{
    use HasFactory;

    protected $fillable  = [
        'user_id',
        'left_team',
        'right_team',
        'left_bv',
        'right_bv',
        'promo_left_bv',
        'promo_right_bv',
        'left_team_m_bv',
        'right_team_m_bv',
        'left_team_bv',
        'right_team_bv',
        'sponsored_team_left_bv',
        'sponsored_team_right_bv',
        'team_left_reorder_bv',
        'team_right_reorder_bv',
        'order_bv',
    ];

    public static function updateBinaryTeam($user, $actor, $take = 50)
    {
        $uplines = User::uplinesByPlacement($user->username, $take);

        $prePosition = $user->position;
        foreach ($uplines as $upline) {
            $uplineUpdate = self::where('user_id', $upline->id)->first();
            $column = $prePosition ? $prePosition . '_team' : null;
            $prePosition = isset($upline->position) ? $upline->position : null;
            $prevTeam = 0;
            if ($uplineUpdate && $column) {
                $prevTeam = $uplineUpdate->$column;
                $uplineUpdate->increment($column);
                $uplineUpdate->save();
            } else if ($column) {
                self::create([
                    'user_id' => $upline->id,
                    $column => 1,
                ]);
            }

            // New - Create points history
            $prevColumn = 'before_'.$column;
            BinaryTeamHistory::create([
                'user_id' => $upline->id,
                'actor_id' => $actor->id,
                $prevColumn => $prevTeam,
                $column => $prevTeam + 1
            ]);
        }

        if (count($uplines) >= $take) {
            $lastUpline = end($uplines);
            BinaryJob::create(['type' => 'user', 'stop_at' => $lastUpline->username]);
        }

        return;
    }

    public static function updateBinaryTeamPV($user, $binaryPoint, $actor, $type, $take = 50)
    {
        $uplines = User::uplinesByPlacement($user->username, $take);
        $config = Configuration::first();
        $currdate = Carbon::now()->toDateTimeString();

        $prePosition = $user->position;
        foreach ($uplines as $upline) {
            $uplineUpdate = self::where('user_id', $upline->id)->first();
            $columnMatch = $prePosition ? $prePosition . '_bv' : null;
            $columnTeam = $prePosition ? $prePosition . '_team_bv' : null;
            $promoColumn = $prePosition ? 'promo_' . $prePosition . '_bv' : null;
            $columnTeamM = $prePosition ? $prePosition . '_team_m_bv' : null;
            $isPromo = false;
            $prevPoints = 0;
            if ($currdate >= $config->promotion_start_date && $currdate <= $config->promotion_end_date) {
                $isPromo = true;
            }
            // return $upline->binarity;
            // if ($upline->binarity) {
                if ($uplineUpdate) {
                    $prevPoints = $uplineUpdate->$columnMatch;
                    if ($isPromo) {
                        $uplineUpdate->$promoColumn = $uplineUpdate->$promoColumn + $binaryPoint;
                    }
                    $uplineUpdate->$columnMatch = $uplineUpdate->$columnMatch + $binaryPoint;
                    $uplineUpdate->$columnTeam = $uplineUpdate->$columnTeam + $binaryPoint;
                    $uplineUpdate->$columnTeamM = $uplineUpdate->$columnTeamM + $binaryPoint;
                    $uplineUpdate->save();
                } 
                else if ($columnMatch && $columnTeam) {
                    $uplineUpdate = self::create([
                        'user_id' => $upline->id,
                        $columnMatch => $binaryPoint,
                        $columnTeam => $binaryPoint,
                        $columnTeamM => $binaryPoint,
                        $promoColumn => $isPromo ? $binaryPoint : 0,
                    ]);
                }

                if (trim(strtolower($type) == 'reorder')) {
                    $reorderColun = 'team_' . $prePosition . '_reorder_bv';
                    $uplineUpdate->$reorderColun = $uplineUpdate->$reorderColun + $binaryPoint;
                    $uplineUpdate->save();
                }

                // New - Create points history
                $prevColumn = 'before_'.$columnMatch;
                BinaryPointHistory::create([
                    'user_id' => $upline->id,
                    'actor_id' => $actor->id,
                    $prevColumn => $prevPoints,
                    $columnMatch => $prevPoints + $binaryPoint,
                    'remark' => 'New points: '.$binaryPoint
                ]);
            // }
            // else {
            //     // New - Create points history
            //     $prevColumn = 'before_'.$columnMatch;
            //     BinaryPointHistory::create([
            //         'user_id' => $upline->id,
            //         'actor_id' => $actor->id,
            //         $prevColumn => $prevPoints,
            //         $columnMatch => $prevPoints + $binaryPoint,
            //         'remark' => 'lost points: '.$binaryPoint
            //     ]);
            // }

            $prePosition = $upline->position;
        }

        if (count($uplines) >= $take) {
            $lastUpline = end($uplines);
            BinaryJob::create([
                'type' => 'bv',
                'bv' => $binaryPoint,
                'order_type' => $type,
                'stop_at' => $lastUpline->username,
                'actor' => $actor->username,
            ]);
        }

        return;
    }

    public static function binaryAwardPoints($user, $bv, $type)
    {
        $countRow =  User::uplinesByPlacementCnt($user->username);
        $take = 1;
        $timesRun = ceil($countRow / $take);
        $rank = 0;
        $localUplines = [$user];

        /**
         *
         * An upline get BV for ranking if he/she sponsored a user who is one of the uplines of the buyer.
         * Therefore, an upline only earns ranking points from the binary tree downline of the users they sponsored.
         *
         */

        while ($rank <= $timesRun) {
            $offset = ($take * $rank);
            $uplines = User::uplinesByPlacement($user->username, $take, $offset);

            foreach ($uplines as $upline) {
                array_push($localUplines, $upline);
            }

            $rank++;
        }

        $prePosition = $user->position;
        foreach ($localUplines as $upline) {
            $columnMatch = $prePosition ? 'sponsored_team_' . $prePosition . '_bv' : null;
            $prePosition = isset($upline->position) ? $upline->position : null;
            $hasSponsor = self::hasSponsor($localUplines, $upline);

            if ($hasSponsor) {
                $uplineUpdate = self::where('user_id', $upline->id)->first();
                $prevPoints = 0;
                if ($uplineUpdate) {
                    $prevPoints = $uplineUpdate->$columnMatch;
                    $uplineUpdate->$columnMatch = $uplineUpdate->$columnMatch + $bv;
                    $uplineUpdate->save();
                } else if ($columnMatch) {
                    self::create(['user_id' => $upline->id, $columnMatch => $bv]);
                }

                // New - Create points history
                $prevColumn = 'before_'.$columnMatch;
                BinaryAwardPointHistory::create([
                    'user_id' => $upline->id,
                    'actor_id' => $user->id,
                    $prevColumn => $prevPoints,
                    $columnMatch => $prevPoints + $bv,
                    'remark' => 'New points: '.$bv
                ]);
            }
        }

        return false;
    }

    private static function hasSponsor($localUplines, $activeUpline)
    {
        foreach ($localUplines as $key => $value) {
            if (strtolower(trim($activeUpline->username)) == strtolower(trim($value->referral))) {
                return true;
            }
        }

        return false;
    }
    
    static function binaryQualifyUpdator()
    {
        $users = User::select('id','username', 'binarity')
            ->take(999)
            ->where(['binarity' => 0])
            ->get(); 

        foreach ($users as $user) {
            $refs = User::select('id','username', 'binarity')->where('referral', $user->username)->get();

            $leftUser = User::select('id','username', 'binarity')
                ->where(['placement' => $user->username, 'position' => 'left'])
                ->first();
            $rightUser = User::select('id','username', 'binarity')
                ->where(['placement' => $user->username, 'position' => 'right'])
                ->first();

            $leftCnt = $rightCnt = 0;
            if ($leftUser && $rightUser) {
                foreach ($refs as $ref) {
                    if ($leftUser->id == $ref->id) {
                        $leftCnt++;
                    }
                    else if ($rightUser->id == $ref->id) {
                        $rightCnt++;
                    }

                    if ($leftCnt && $rightCnt) {
                        $left = $right = 0;
                        $user->binarity = 1;
                        $user->save();
                        break 1;
                    }
                }
            }

            if (!$leftCnt && $leftUser) {
                $leftTeams = User::downlinesByPlacement($leftUser->username, 999);
                foreach ($leftTeams as $leftTeam) {
                    foreach ($refs as $ref) {
                        if ($ref->id == $leftTeam->id) {
                            $leftCnt++;
                            break 2;
                        }
                    }
                }
            }
            
            if (!$rightCnt && $rightUser) {
                $rightTeams = User::downlinesByPlacement($rightUser->username, 999);
                foreach ($rightTeams as $rightTeam) {
                    foreach ($refs as $ref) {
                        if ($ref->id == $rightTeam->id) {
                            $rightCnt++;
                            break 2;
                        }
                    }
                }
            }

            if ($leftCnt && $rightCnt) {
                $leftCnt = $rightCnt = 0;
                $user->binarity = 1;
                $user->save();
            }
        }

        return true;
    }
}
