<?php

namespace App\Mail;

use App\Models\User;
use App\Models\EmailTemplate;
use App\Models\Invitee;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use App\Models\WebsiteSetting;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Mailables\Envelope;

class RegConfirmation extends Mailable
{
    use Queueable, SerializesModels;
    public $detail;
    public $title = 'Registration Fee Comfirmation from Campmeeting 2025';
    /**
     * Create a new message instance.
     */
    public function __construct($detail)
    {
        $this->detail = $detail;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {

        return new Envelope(
            from: 'info@believerscampmeeting.com',
            subject: $this->title,
        );
    }


    public function content(): Content
    {
        return new Content(
            view: 'emails.registration-confirmation',
        );
    }
    /**
     * Get the message content definition.
     */

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
