<?php

namespace App\Http\Controllers;

use GuzzleHttp\Client;
use App\Models\Invitee;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;


class FlutterwavePaymentController extends Controller
{
    private $baseUrl;
    private $secretKey;

    public function __construct()
    {
        $this->baseUrl = env('FLW_BASE_URL');
        $this->secretKey = env('FLW_SECRET_KEY');
    }

    public function initializePayment(Request $request)
    {

        if (session('reg_type')) {
            session()->flush([
                'reg_type',
                'reg_category',
                'nam',
                'email',
                'phone',
                'gender',
            ]);
        }
        session([
            'reg_type' => $request->reg_type,
            'reg_category' => $request->reg_category,
            'name' => $request->name,
            'email' => $request->email,
            'gender' => $request->gender,
            'phone' => $request->phone,
        ]);
        $amount = 0;
        if ($request->reg_category == "Children") {
            $amount = 2000;
        }
        if ($request->reg_category == "Children") {
            $amount = 4000;
        }
        if ($request->reg_category == "Children") {
            $amount = 7000;
        }

        $data = [
            "tx_ref" => uniqid(),
            "amount" => $amount, // Amount in NGN
            "currency" => "NGN",
            "redirect_url" => route('store-onlineInvitee'),
            "payment_options" => "card, banktransfer",
            "customer" => [
                "email" => $request->email,
                "name" => $request->name,
            ],
            "customizations" => [
                "title" => "The Grace Trybe",
                "description" => "Payment for Campmeeting 2025",
            ]
        ];


        try {
            $response = Http::post("https://api.flutterwave.com/v3", [
                'headers' => [
                    'Authorization' => "Bearer {$this->secretKey}",
                    'Content-Type' => 'application/json',
                ],
                'json' => $data,
            ]);

            $body = json_decode($response->getBody(), true);
            if ($body['status'] === 'success') {
                return redirect()->away($body['data']['link']); // Redirect to payment page
            }

            return back()->with('error', 'Unable to initialize payment');
        } catch (\Exception $e) {
            Log::error('Flutterwave Payment Error: ' . $e->getMessage());
            return back()->with('error', 'Payment failed. Try again later.');
        }
    }

    public function storeInvitee(Request $request)
    { // return count($request->first_name);
        DB::beginTransaction();
        if (session('reg_type')) {
            try {

                if (session('reg_type') == "personal") {
                    Invitee::create([
                        'first_name' => session('name'),
                        'email' => session('email'),
                        'phone' => session('phone'),
                        'gender' => session('gender'),
                        'reg_mode' => "online",
                        'invitee_id' => substr(rand(1, 100000000), 0, 6),
                    ]);
                }

                DB::commit();
                if (session('reg_type')) {
                    session()->flush([
                        'reg_type',
                        'name',
                        'email',
                        'phone',
                        'gender',
                    ]);
                }
                return redirect()->route('reg-success');
            } catch (\Exception $e) {
                return $e;
                DB::rollBack();
            }
        }
        return redirect()->back('error', 'Opps! Something went wrong, please try it again.');
    }

    public function handleCallback(Request $request)
    {
        $transactionId = $request->query('transaction_id');

        if (!$transactionId) {
            return redirect()->route('home')->with('error', 'Transaction not found.');
        }

        $client = new Client();

        try {
            $response = $client->get("{$this->baseUrl}/transactions/{$transactionId}/verify", [
                'headers' => [
                    'Authorization' => "Bearer {$this->secretKey}",
                    'Content-Type' => 'application/json',
                ],
            ]);

            $body = json_decode($response->getBody(), true);

            if ($body['status'] === 'success' && $body['data']['status'] === 'successful') {
                // Store transaction details in DB
                return redirect()->route('home')->with('success', 'Payment successful');
            }

            return redirect()->route('home')->with('error', 'Payment verification failed');
        } catch (\Exception $e) {
            Log::error('Flutterwave Callback Error: ' . $e->getMessage());
            return redirect()->route('home')->with('error', 'Error verifying transaction.');
        }
    }
}
