@extends('layouts.auth.user')
@section('title', 'Registration Payment')
@section('content')
    <div class="limiter">
        <div class="container-login100">
            <div class="row">
                <div class="col-md-1"></div>
                <div class="col-md-10 mb-3">
                    <p class="text-center mb-3"><x-site-logo /></p>
                    <div class="wrap-login100">
                        <form class="login100-form" method="POST" action="{{ route('event-register') }}">
                            @csrf
                            @if (session('error'))
                                <p class="alert alert-danger" role="alert">
                                    {{ session('error') }}
                                </p>
                            @endif
                            <div class="form-group py-3">
                                {{-- <select name="reg_type" required class="input100 form-control mb-3" id="payment">
                                    <option value="">-- Select Payment Method --</option>
                                    @if (session('reg_type') == 'bulk')
                                    <option value="offline">Offline</option>
                                    @else
                                    <option value="online">Online</option>
                                    <option value="offline">Offline</option>
                                @endif
                                </select> --}}
                                <input type="hidden" name="reg_type" value="offline">
                                <div id="bulkReg" class="mb-3" style="">
                                    <p>Please note that all registration will be pending until payment is confirmed.

                                    <ul class="list-group">
                                        <li class="list-group-item">Account Name : {{ $config->acct_name ? $config->acct_name : 'THE GRACE TRYBE MISSIONS' }}
                                        </li>
                                        <li class="list-group-item">Account Number :
                                            {{ $config->acct_number ? $config->acct_number : '1229362432' }}</li>
                                        <li class="list-group-item">Bank Name : {{ $config->bank ? $config->bank : 'ZENITH BANK' }}</li>
                                    </ul>
                                    </p>
                                    <p>Number of candidates {{ $total }}</p>
                                    @if (session('reg_type') == 'personal')
                                        <p>Total Amount to be paid <x-amount :amount="$stotal_fee" /></p>
                                    @else
                                        <p>Total Amount to be paid <x-amount :amount="$total_fee" /></p>
                                    @endif
                                    @if (session('accomodation'))
                                        <p>Selected Accomodation : {{session('accomodation')}}</p>
                                    @endif
                                </div>

                                {{-- <div class="car-body mb-3" id="singleReg" style="display: none">
                                    <p>Please note that all registration will be pending until payment is confirmed. <br>

                                        <span>Number of candidates {{$total}}</span> <br>
                                        <span class="py-3">Total Amount to be paid <x-amount :amount="$total_fee" /></span>
                                    </p>

                                </div> --}}

                                <div class="container-login100-form-btn">
                                    <button class="login100-form-btn">
                                        Complete Registration
                                    </button>
                                </div>


                        </form>
                    </div>
                </div>
                <div class="col-md-1"></div>
            </div>
        </div>
    </div>

    <script src="{{ asset('AdminAuth/js/jquery.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('#payment').on('change', function() {
                if (this.value == 'online') {
                    $("#singleReg").show();
                    $("#bulkReg").hide();
                }
                if (this.value == 'offline') {
                    $("#bulkReg").show();
                    $("#singleReg").hide();
                }
                if (this.value == '') {
                    $("#singleReg").hide();
                    $("#bulkReg").hide();
                }

            });
        });
    </script>
@endsection
