<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js"></script>
@php
    $config = App\Models\Configuration::first();
    $currency_code = $config->currency_code;
@endphp
<script>
    function getPackage() {
        var package = $('.activation-form #package').val();
        var username = "{{auth()->user()->username}}";
        const orderType = localStorage.getItem('orderType');
        if (orderType == 'upgrade') {
            window.location.href = "{{ route('package-upgrade') }}"
            return;
        }

        localStorage.setItem("package", package);

        $.ajax({
            type: 'post',
            data: {
                package: package,
                username: username,
                _token: "{{ csrf_token() }}"
            },
            url: "{{ route('fetch-package') }}",
            success: function(response) {
                if (response.status == 'ok') {
                    var package_pv = response.package.min_pv;
                    localStorage.setItem("package_pv", response.package.min_pv);
                    document.getElementById("pv").innerHTML = package_pv + 'PV';
                    document.getElementById("pvMessage").style.display = 'block';

                } else if (response.status == 'error') {
                    if (response.message) {
                        alert(response.message);
                    }
                    else {
                        alert('Oops! Something happened, please reload the page.');
                    }
                }
            }
        })
    }

    function getUpgradePackage() {
        var package = $('.activation-form #package').val();
        var username = "{{auth()->user()->username}}";
        const orderType = localStorage.getItem('orderType');
        if (orderType == 'activation' && pageRole && pageRole == 'upgrade') {
            window.location.href = "{{ route('package-activation') }}"
            return;
        }

        localStorage.setItem("package", package);

        $.ajax({
            type: 'post',
            data: {
                package: package,
                username: username,
                _token: "{{ csrf_token() }}"
            },
            url: "{{ route('fetch-upgrade-package') }}",
            success: function(response) {
                if (response.status == 'ok') {
                    localStorage.setItem("package_pv", response.requiredPV);
                    document.getElementById("pv").innerHTML = response.requiredPV + 'PV';
                }
                else if (response.status == 'error') {
                    alert('Oops! Something happened, please reload the page.');
                }
            }
        })
    }

    $(document).ready(function() {
        var package_pv = localStorage.getItem("package_pv");
        var package = localStorage.getItem("package");
        var orderType = localStorage.getItem("orderType");
        var userPackages = localStorage.getItem("userPackages");
        if (userPackages) {
            packagesView(JSON.parse(userPackages));
        }
        if (orderType) {
            $('#overviewType').val(orderType);
        }

        if (package && package_pv) {
            if (pageRole != 'orderOverview') {                
                document.getElementById("pvMessage").style.display = 'block';
            }
            $('#package').val(package);
            $('#overviewPackage').val(package);
            if (pageRole && (pageRole == 'shoppingCart' || pageRole == 'upgrade')) {
                document.getElementById("pv").innerHTML = package_pv + 'PV';
            }
        }

        if (pageRole && pageRole == 'orderSuccess') {
            localStorage.removeItem("package_pv");
            localStorage.removeItem("package");
            localStorage.removeItem("orderType");
            localStorage.removeItem("userPackages");
        }
    });

    function packagesView(packages) {
        let view = '<option value="">Select Package</option>';
        if (packages.length > 0) {
            for (let index = 0; index < packages.length; index++) {
                view = view + ' <option value="'+packages[index].name+'">'+packages[index].name+'</option>';
            }
        }
        else {
            view = '<option value="">Upgrade Unavailable</option>';
        }

        const pkgView = document.getElementById("package");
        if (pkgView) {
            pkgView.innerHTML = view
        }
    }


</script>