@extends('layouts.admin')
@section('title','Social Setting Manager')
@section('content')

<div class="min-height-200px">
    <div class="page-header">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <div class="title">
                    <h4>Social Setting Manager</h4>
                </div>
                <nav aria-label="breadcrumb" role="navigation">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{route('adminDashboard')}}">Admin</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                           Social Setting
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="col-md-6 col-sm-12 text-right">
                <div class="dropdown">
                    <a
                        class="btn btn-primary"
                        href="{{route('admin.social-setting.create')}}"
                        role="button"
                    >
                    <i class="bi bi-plus-circle"></i>
                       New
                    </a>
                 
                </div>
            </div>
        </div>
    </div>
    <div class="card-box pb-10">
        <div class="h5 pd-20 mb-0"></div>
        @if (session('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <strong>Success!</strong> {{session('message')}}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        @endif
        <table class="table nowrap">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Icon </th>
                    <th>Url</th>
                    <th>Date</th>
                    <th> </th>
                </tr>
            </thead>
            <tbody>
                @forelse ($accounts as $account)
                <tr>
                    <td>{{ucfirst($account->name)}}</td>
                    <td><i class="{{$account->icon}} fa-2x" aria-hidden="true"></i></td>
                    <td><a href="{{$account->url}}" target="_blank">{{$account->url}}</a></td>

                    <td><x-date-format :date="$account->created_at"/></td>
                    <td>
                        <form action="{{route('admin.social-setting.destroy',$account->id)}}" method="POST">
                            @csrf
                            <a href="{{route('admin.social-setting.show',$account->id)}}"
                                class="btn btn-info btn-sm text-white">
                                <i class="fa fa-eye"></i>
                            </a>
                            @method('DELETE')
                            <button type="submit" onclick="return confirm('Continue With Delete?')"
                                class="btn btn-danger btn-sm" title="Delete Account"><i
                                    class="fa fa-trash"></i></button>
                        </form>
                    </td>
                </tr>
                @empty
                <table>
                    <tr>
                        <p class="text-center">No record found</p>

                    </tr>
                </table>
                @endforelse                
            </tbody>
        </table>
    </div>
</div>

@endsection