@extends('layouts.admin')
@section('title','Privacy Policy')
@section('content')

<div class="min-height-200px">
    <div class="page-header">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <div class="title">
                    <h4>Privacy Policy</h4>
                </div>
                <nav aria-label="breadcrumb" role="navigation">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{route('adminDashboard')}}">Admin</a>
                        </li>
                        <li class="breadcrumb-item" aria-current="page">
                            Privacy Policy
                        </li>
                       
                    </ol>
                </nav>
            </div>
            {{-- <div class="col-md-6 col-sm-12 text-right">
                <div class="dropdown">
                    <a class="btn btn-primary" href="{{route('admin.email-template.index')}}" role="button">
                        Email Templates
                    </a>

                </div>
            </div> --}}
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="pd-20 card-box mb-30">
                @if (session('message'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <strong>Success!</strong> {{session('message')}}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif
                <form action="{{route('admin.privacy-update')}}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="form-group">
                        <input type="text" value="{{$privacy ? $privacy->title : ''}}" class="form-control" name="title" placeholder="Enter Title here" id="">
                    </div>
                    <div class="html-editor pd-20 card-box mb-30">
						<h4 class="h4 text-blue">Content</h4>
						<textarea
                        name="content"
							class="textarea_editor form-control border-radius-0"
							placeholder="Enter text ..."
						>{!! $privacy ? $privacy->content : '' !!}</textarea>
					</div>
                   
                    <div class="form-group">
                        <button type="submit" class="btn btn-primary">Update Details</button>
                    </div>
                </form>


            </div>
        </div>
        <div class="col-md-4">
            
        </div>
    </div>
</div>

@endsection
