@extends('layouts.admin')
@section('title','My Profile')
@section('content')
<div class="min-height-200px">
    <div class="page-header">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <div class="title">
                    <h4>My Profile</h4>
                </div>
                <nav aria-label="breadcrumb" role="navigation">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{route('adminDashboard')}}">Admin</a>
                        </li>

                        <li class="breadcrumb-item active" aria-current="page">
                            Profile
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="col-md-6 col-sm-12 text-right">
                {{-- <div class="dropdown">
                    <a class="btn btn-primary" href="{{route('admin.users')}}" role="button">
                Users
                </a>

            </div> --}}
        </div>
    </div>
</div>
<div class="row mb-10">
    <div class="col-md-12">
        <div class="card-box height-100-p overflow-hidden">
            <div class="profile-tab height-100-p">
                <div class="tab height-100-p">
                    <ul class="nav nav-tabs customtab" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" href="{{route('admin.profile')}}" role="tab">Profile</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{route('admin.password')}}" role="tab">Password </a>
                        </li>

                    </ul>

                </div>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 mb-30">
        <div class="pd-20 card-box height-100-p">
            <div class="profile-photo">
                <img src="{{file_exists($admin->photo) ? asset($admin->photo) : asset('admin-ui/vendors/images/photo1.jpg')}}" alt="{{ucfirst($admin->username)}}" class="avatar-photo" />

            </div>
            <h5 class="text-center h5 mb-0">{{ucfirst($admin->username)}}</h5>
            <p class="text-center text-muted font-14">
                {{ucfirst($admin->role)}}
            </p>
            <div class="profile-info">
                <h5 class="mb-20 h5 text-blue">Contact Information</h5>
                <ul>
                    <li>
                        <span>Email Address:</span>
                        {{$admin->email}}
                    </li>
                    <li>
                        <span>Phone Number:</span>
                        {{$admin->phone}}
                    </li>
                    <li>
                        <span>Country:</span>
                        {{$admin->country}}
                    </li>
                    <li>
                        <span>Address:</span>
                        {{$admin->address}}<br />
                        {{$admin->city.''}} {{$admin->state}}
                    </li>
                </ul>
            </div>

        </div>
    </div>
    <div class="col-xl-8 col-lg-8 col-md-8 col-sm-12 mb-30">
        <div class="card-box height-100-p overflow-hidden">
            <div class="profile-tab height-100-p">
                <div class="tab height-100-p">
                    <div class="pd-20 card-box mb-30">
                        @if (session('message'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <strong>Success!</strong> {{session('message')}}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        @endif
                        <form class="form-horizontal" action="{{route('admin.profile-update')}}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="form-group">
                                <label>Username</label>
                                <input class="form-control" readonly placeholder="Username" value="{{$admin->username}}" type="text" required name="username" />

                            </div>
                            <div class="form-group">
                                <label>Email</label>
                                <input class="form-control" value="{{$admin->email}}" name="email" required type="email" placeholder="Enter Email" />

                            </div>
                            <div class="form-group">
                                <label>First Name</label>
                                <input class="form-control" value="{{$admin->first_name}}" name="first_name" placeholder="First Name" type="text" />
                            </div>
                            <div class="form-group">
                                <label>Last Name</label>
                                <input class="form-control" value="{{$admin->last_name}}" placeholder="Last Name" name="last_name" type="text" />
                            </div>
                            <div class="form-group">
                                <label>Contact</label>
                                <input class="form-control" maxlength="12" value="{{$admin->phone}}" placeholder="Phone Number" name="phone" type="text" />
                            </div>

                            <div class="form-group">
                                <label>Address</label>
                                <input class="form-control" value="{{$admin->address}}" placeholder="Address" name="address" type="text" />
                            </div>
                            <div class="form-group">
                                <label>City</label>
                                <input class="form-control" value="{{$admin->city}}" placeholder="City" name="city" type="text" />
                            </div>
                            <div class="form-group">
                                <label>State</label>
                                <input class="form-control" placeholder="State" value="{{$admin->state}}" name="state" type="text" />
                            </div>
                            <div class="form-group">
                                <label for=" ">Country</label>
                                <select name="country" class="form-control">
                                    <option value="{{$admin->country ?? ''}}">{{$admin->country ?? ''}}</option>
                                    <x-country-list />
                                </select>
                            </div>
                            <div class="form-group">
                                <label for=" ">About Me</label>
                                <textarea name="bio" class="form-control" cols="30" rows="10">{{$admin->bio}}</textarea>
                            </div>
                            <div class="form-group">
                                <label for=" ">Profile Photo</label>
                                <input type="file" name="photo" id="">
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">Update Details</button>
                            </div>
                        </form>


                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
@endsection
