@extends('layouts.admin')
@section('title','Admin Details')
@section('content')

<div class="min-height-200px">
    <div class="page-header">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <div class="title">
                    <h4>{{ucfirst($admin->username)}}'s Details</h4>
                </div>
                <nav aria-label="breadcrumb" role="navigation">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{route('adminDashboard')}}">Admin</a>
                        </li>
                        <li class="breadcrumb-item" aria-current="page">
                            Sub Admins
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Details
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="col-md-6 col-sm-12 text-right">
                <div class="dropdown">
                    <a class="btn btn-primary" href="{{route('admin.admins.index')}}" role="button">
                        Admin Manager
                    </a>

                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-8">
            <div class="pd-20 card-box mb-30">
                @if (session('message'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <strong>Success!</strong> {{session('message')}}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif
                <form action="{{route('admin.admins.update',$admin->id)}}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="form-group">
                        <label>Username</label>
                        <input class="form-control" readonly placeholder="Username" value="{{$admin->username}}" type="text" required name="username" />
                        @error('username')
                        <span class="text-danger">{{$message}}</span>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label>Email</label>
                        <input class="form-control" value="{{$admin->email}}" name="email" required type="email" placeholder="Enter Email" />
                        @error('email')
                        <span class="text-danger">{{$message}}</span>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label>First Name</label>
                        <input class="form-control" value="{{$admin->first_name}}" name="first_name" placeholder="First Name" type="text" />
                    </div>
                    <div class="form-group">
                        <label>Last Name</label>
                        <input class="form-control" value="{{$admin->last_name}}" placeholder="Last Name" name="last_name" type="text" />
                    </div>
                    <div class="form-group">
                        <label>Contact</label>
                        <input class="form-control" maxlength="12" value="{{$admin->phone}}" placeholder="Contact Phone Number" name="phone" type="text" />
                        @error('phone')
                        <span class="text-danger">{{$message}}</span>
                        @enderror
                    </div>
                    {{-- <div class="form-group">
                        <label>Change Password</label>
                        <input class="form-control" minlength="6" maxlength="10" placeholder="Password" name="password" type="password" />
                       
                    </div> --}}
                    <div class="form-group">
                        <label for="">Role</label>
                        <select name="role" required class="form-control">
                            <option value="{{$admin->role}}">{{$admin->role}}</option>
                            <option value="">--- Select ---</option>
                            <option value="user-manager">User Manager</option>
                            <option value="content-manager">Content Manager</option>
                            <option value="inventory-manager">Inventory Manager</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Address</label>
                        <input class="form-control" value="{{$admin->address}}" placeholder="Address" name="address" type="text" />
                    </div>
                    <div class="form-group">
                        <label>City</label>
                        <input class="form-control" value="{{$admin->city}}" placeholder="City" name="city" type="text" />
                    </div>
                    <div class="form-group">
                        <label>State</label>
                        <input class="form-control" placeholder="State" value="{{$admin->state}}" name="state" type="text" />
                    </div>
                    <div class="form-group">
                        <label for=" ">Country</label>
                        <select name="country" class="form-control">
                            <option value="{{$admin->country}}">{{$admin->country}}</option>
                            <x-country-list />
                        </select>
                    </div>
                    <div class="form-group">
                        <label>About Me</label>
                        <textarea name="bio" class="form-control" id="" cols="30" rows="10">{{$admin->bio}}</textarea>
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn btn-success">Update Details</button>
                    </div>
                </form>


            </div>
        </div>
        <div class="col-md-4">
            <div class="pd-20 card-box">
                <div class="profile-photo">                   
                    <img src="{{$admin->photo ? asset($admin->photo) : asset('admin-ui/vendors/images/photo1.jpg')}}" alt="Profile Photo" class="avatar-photo" />                   
                </div>
                <h5 class="text-center h5 mb-0">{{$admin->fullname() ? ucfirst($admin->fullname()) : ucfirst($admin->username)}}</h5>
                <p class="text-center text-muted font-14">
                    {{str_replace('-',' ',ucfirst($admin->role))}}
                </p>


            </div>
        </div>
    </div>
</div>

@endsection
