<?php

namespace App\Services;

use App\Models\AdminLog;
use App\Models\SocialSetting;
use Illuminate\Support\Facades\Auth;

class SocialSettingService
{
    public static function allAccounts($take)
    {
        return SocialSetting::latest('id')->paginate($take ?: 20);
    }
    public static function store(array $data)
    {
        $account = SocialSetting::create([
            'name' => $data['name'],
            'icon' => $data['icon'],
            'url' => $data['url'],
        ]);

        AdminLog::createAdminLog(
            Auth::user()->id,
            $account->id,
            'social_settings',
            ucfirst(Auth::user()->username) . ' Added New Social Account Details'
        );
    }
    public static function edit($id)
    {
        $account = SocialSetting::find($id);
        return $account;
    }
    public static function update($id, array $data)
    {
        $account = SocialSetting::find($id);
        $account->update($data);
        AdminLog::createAdminLog(
            Auth::user()->id,
            $account->id,
            'social_settings',
            ucfirst(Auth::user()->username) . ' Updated this Social Account Details'
        );
    }
    public static function delete($id)
    {
        $account = SocialSetting::find($id);
        $account->delete();
        AdminLog::createAdminLog(
            Auth::user()->id,
            $account->id,
            'social_settings',
            ucfirst(Auth::user()->username) . ' Deleted this Account'
        );
    }
}
