<?php

namespace App\Services;

use App\Models\Epin;
use App\Models\Admin;
use App\Models\AdminLog;
use Illuminate\Support\Str;
use App\Models\Configuration;
use Illuminate\Support\Facades\Auth;

class EpinService
{
    public static function allCodes($take)
    {
        return Epin::latest('id')->paginate($take ?: 20);
    }

    public static function store($number_of_pins)
    {
        $config = Configuration::first();
        for ($i = 1; $i <= $number_of_pins; $i++) {
            $pin = Epin::create([
                'admin_id' => Auth::guard('admin')->user()->id,
                'type' => 'registration',
                'amount' => $config ? $config->registration_fee : 5000,
                'code' => Str::upper(Str::random(10)),
            ]);
        }
        $adm = Auth::guard('admin')->user();
        AdminLog::createAdminLog(
            $adm->id,
            $pin->id,
            'epins',
            'New Epin Generated by' . ucfirst($adm->username)
        );
    }
    public static function edit($id)
    {
        return Epin::find($id);
    }

    public static function delete($id)
    {
        $pin = Epin::find($id);
        $pin->delete();
        $adm = Auth::user();
        AdminLog::createAdminLog(
            $adm->id,
            $pin->id,
            'epins',
            'Epin Deleted by' . ucfirst($adm->username)
        );
    }
}
