<?php

namespace App\Services;

use App\Models\User;

class AutomaticUserPlacementService
{
    /**
     * Class constructor.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    public static function addToPlacement($parentUsername, $newUser)
    {
        $parentInfo = User::select('id', 'username', 'placement', 'position', 'auto_placement')
            ->where('username', $parentUsername)->first();

        // Placement on direct placement upline is done here
        $parentLegsUsers = self::binaryLegsUpdate($parentInfo->username, $newUser->username);

        if (count($parentLegsUsers) == 2) {
            // Automatic spillover

            if ($parentInfo->auto_placement == 'far_left') {
                // continue auto placement left-ward
                self::leftRightWardAutoPlacement($parentInfo->username, $newUser->username, 'left');
            }
            else if ($parentInfo->auto_placement == 'far_right') {
                // continue auto placement right-ward
                self::leftRightWardAutoPlacement($parentInfo->username, $newUser->username, 'right');
            }
            else if ($parentInfo->auto_placement == 'full_left') {
                // continue auto placement on left full team
                $positionUser = null;
                if (isset($parentLegsUsers[0]) && $parentLegsUsers[0]->position == 'left') {
                    $positionUser = $parentLegsUsers[0];
                }
                else if (isset($parentLegsUsers[1]) && $parentLegsUsers[1]->position == 'left') {
                    $positionUser = $parentLegsUsers[1];
                }

                if ($positionUser) {
                    $positionParent = self::binaryLegsUpdate($positionUser->username, $newUser->username);

                    if (count($positionParent) == 2) {
                        self::evenAutoPlacement($positionUser->username, $newUser->username);
                    }
                }
            }
            else if ($parentInfo->auto_placement == 'full_right') {
                // continue auto placement on right full team
                $positionUser = null;
                if (isset($parentLegsUsers[0]) && $parentLegsUsers[0]->position == 'right') {
                    $positionUser = $parentLegsUsers[0];
                }
                else if (isset($parentLegsUsers[1]) && $parentLegsUsers[1]->position == 'right') {
                    $positionUser = $parentLegsUsers[1];
                }

                if ($positionUser) {
                    $positionParent = self::binaryLegsUpdate($positionUser->username, $newUser->username);

                    if (count($positionParent) == 2) {
                        self::evenAutoPlacement($positionUser->username, $newUser->username);
                    }
                }
            }
            else {
                // 'even' auto placement
                self::evenAutoPlacement($parentInfo->username, $newUser->username);
            }
        }

        return true;
    }

    private static function leftRightWardAutoPlacement($parentUsername, $newUsername, $position)
    {
        $downlineCnt = User::downlinesByPositionWardCnt($parentUsername, $position);
        $take = 20;
        $timesRun = ceil($downlineCnt / $take);
        $rank = 0;

        while ($rank <= $timesRun) {
            $offset = ($take * $rank);
            $downlines = User::downlinesByPositionWard($parentUsername, $position, $take, $offset);

            foreach ($downlines as $downline) {
                $legsUpdate = self::binaryLegsUpdate($downline->username, $newUsername, $position);

                if (count($legsUpdate) != 2) {
                    $rank =  1 + $timesRun;
                    return true;
                }
            }

            $rank++;

            set_time_limit(300);
        }
    }

    private static function evenAutoPlacement($parentUsername, $newUsername)
    {
        $downlineCnt = User::downlinesByPlacementCnt($parentUsername);
        $take = 20;
        $timesRun = ceil($downlineCnt / $take);
        $rank = 0;

        while ($rank <= $timesRun) {
            $offset = ($take * $rank);
            $downlines = User::downlinesByPlacement($parentUsername, $take, $offset);

            foreach ($downlines as $downline) {
                $legsUpdate = self::binaryLegsUpdate($downline->username, $newUsername);

                if (count($legsUpdate) != 2) {
                    $rank =  1 + $timesRun;
                    return true;
                }
            }

            $rank++;

            set_time_limit(300);
        }
    }

    private static function binaryLegsUpdate($parentUsername, $newUsername, $position=null)
    {
        $results = User::select('id', 'username', 'placement', 'position')
            ->where('placement', $parentUsername)
            ->get();

        if (count($results) == 0) {
            if (!$position) {
                $position = 'left';
            }

            $update = self::updateUserPlacement($parentUsername, $newUsername, $position);

            return [$update] ?: [];
        }
        else if (count($results) == 1) {
            $position = 'right';
            if ($results[0]->position == 'right') {
                $position = 'left';
            }

            $update = self::updateUserPlacement($parentUsername, $newUsername, $position);

            return [$update] ?: [];
        }

        return $results;
    }

    private static function updateUserPlacement($parentUsername, $newUsername, $position)
    {
        $update = User::where('username', $newUsername)->update([
            'placement' => $parentUsername,
            'position' => $position,
        ]);

        return $update ?: false;
    }


}
