<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class LeadershipBonus extends Model
{
    use HasFactory;
    protected $fillable = [
        'rank_id',
        'profit'
    ];

    public function rank(): BelongsTo
    {
        return $this->BelongsTo(RankQualification::class, 'rank_id');
    }
}
