<?php

namespace App\Http\Controllers\Auth;

use Carbon\Carbon;
use App\Models\User;
use Illuminate\Http\Request;
use App\Mail\EmailVerification;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Validator as ValidatorCustom;

class EmailVerificationController extends Controller
{
    public function show()
    {
        $user = Auth::user();
        if (!$user) {
            return redirect()->route('register');
        }

        if ($user->email_verified_at) {
            return redirect()->route('personal.show');
        }

        return view('auth.email-verification', ['user' => $user]);
    }

    public function verify(Request $request)
    {
        $validate = Validator::make($request->all(), [
            'email_code' => 'required'
        ]);

        $user = Auth::user();
        if (!$user) {
            return redirect()->route('register');
        }

        $user = User::where(['email_code' => $request->email_code, 'id' => $user->id])->first();

        if (!$user) {
            $validate->after(function (ValidatorCustom $validate) {
                $validate->errors()->add('invalid', 'Invalid verification code, please try it again.');
            });
        }

        if ($validate->fails()) {
            return redirect()->route('verifyEmail')->withErrors($validate);
        }

        $user->email_verified_at = Carbon::now()->toDateTimeString();
        $user->status = 'Active';
        $user->save();

        Auth::login($user, true);

        return redirect()
            ->route('personal.show')
            ->with('status', 'Email verification was successful');
    }

    public function resendCode()
    {
        $user = Auth::guard('web')->user();

        if (!$user) {
            return redirect()->route('login');
        }

        if ($user->email_verified_at) {
            return redirect()->route('personal.show');
        }

        //$this->sendEmail($user);

        return redirect()->route('verifyEmail')->with('status', 'A verification code sent successfully');
    }

    // private function sendEmail($user)
    // {
    //     $user->email_code = rand(100000, 999999);
    //     $user->save();

    //     Mail::to($user)->send(new EmailVerification($user));

    //     return true;
    // }
}
