<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Services\AdminService;
use Illuminate\Http\Request;

class AdminManagerController extends Controller
{
    public function __construct(
        private AdminService $adminService
    ) {}

    /**
     * Display a listing of all sub-admins.
     */
    public function index()
    {
        $admins = $this->adminService->allAdmins(request()->take);
        return view('admin.admins.index', compact('admins'));
    }

    /**
     * Show the form for creating a new Admin.
     */
    public function create()
    {
        return view('admin.admins.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'username' => 'required|unique:admins,username',
            'email' => 'required',
            'phone' => 'required|unique:admins,phone',
            'role' => 'required|in:user-manager,content-manager,inventory-manager',
        ]);
        $this->adminService->store($request);
        return redirect()->back()->with('message', 'New Admin Added Succssfully!');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $admin = $this->adminService->edit($id);
        if (!$admin) {
            abort(404);
        }
        return view('admin.admins.edit', compact('admin'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate([
            'email' => 'required',
            'role' => 'required|in:user-manager,content-manager,inventory-manager',
        ]);
        $this->adminService->update($id, $request);
        return redirect()->back()->with('message', 'Admin Details Updated Succssfully!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $admin = $this->adminService->edit($id);
        if (!$admin) {
            abort(404);
        }
        $this->adminService->delete($id);
        return redirect()->back()->with('message', 'Admin Details Deleted Succssfully!');
    }
}
